/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.code_scopes;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CodeScopesMetricsIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="metrics")
    private MetricsIndex metricsIndex;
    @DeltaSource(value=MetricsIndex.class, indexName="metrics")
    private KeyDelta metricsDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="code-scopes-metrics")
    private MetricsIndex codeScopesMetricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="code-scopes-mapping")
    private CodeScopesMappingIndex codeScopesMappingIndex;
    @IndexAccess(value=EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, indexName="code-scopes-mapping")
    private CodeScopesMappingIndex previousCodeScopesMappingIndex;

    public void execute() throws Exception {
        List addedOrChangedPaths = UniformPathCompatibilityUtil.convertCollection((Collection)this.metricsIndex.rawIndexKeysToUniformPaths(this.metricsDelta.getAddedOrChangedKeysAsBytes()));
        List deletedPaths = UniformPathCompatibilityUtil.convertCollection((Collection)this.metricsIndex.rawIndexKeysToUniformPaths(this.metricsDelta.getDeletedKeysAsBytes()));
        List<String> partitions = this.getPartitions();
        this.handleAddedOrChangedKeys(addedOrChangedPaths, partitions);
        this.handleDeletedKeys(deletedPaths, partitions);
    }

    private void handleAddedOrChangedKeys(List<UniformPath> addedOrChangedPaths, List<String> partitions) throws StorageException {
        if (addedOrChangedPaths.isEmpty()) {
            return;
        }
        Map<UniformPath, CodeScopeName> mappings = this.codeScopesMappingIndex.getMappings(addedOrChangedPaths);
        for (String partition : partitions) {
            PairList<String, Serializable> valuesToWrite = this.getValuesToWrite(mappings, partition);
            if (valuesToWrite.isEmpty()) continue;
            this.codeScopesMetricsIndex.setMetricValues(valuesToWrite, partition);
        }
    }

    private PairList<String, Serializable> getValuesToWrite(Map<UniformPath, CodeScopeName> uniformPathsWithCodeScope, String partition) throws StorageException {
        PairList valuesToWrite = new PairList();
        Map metricValues = this.metricsIndex.getMetricValues(partition, uniformPathsWithCodeScope.keySet());
        for (Map.Entry entry : metricValues.entrySet()) {
            UniformPath uniformPath = (UniformPath)entry.getKey();
            UniformPath transformedPath = uniformPath.asCodeScopePath(uniformPathsWithCodeScope.get(uniformPath));
            valuesToWrite.add((Object)transformedPath.toStringAsMigrationFrontier(), (Object)((Serializable)entry.getValue()));
        }
        return valuesToWrite;
    }

    private void handleDeletedKeys(List<UniformPath> deletedPaths, List<String> partitions) throws StorageException {
        if (deletedPaths.isEmpty()) {
            return;
        }
        Map<UniformPath, CodeScopeName> previousCodeScopeMappings = this.previousCodeScopesMappingIndex.getMappings(deletedPaths);
        List keysToDelete = previousCodeScopeMappings.entrySet().stream().map(entry -> ((UniformPath)entry.getKey()).asCodeScopePath((CodeScopeName)entry.getValue())).map(UniformPath::toStringAsMigrationFrontier).collect(Collectors.toList());
        this.codeScopesMetricsIndex.removeEntries(keysToDelete, partitions);
    }

    private List<String> getPartitions() throws StorageException {
        ArrayList<String> partitions = new ArrayList<String>();
        List metricSources = this.metricSchemaIndex.getMetricSources();
        for (IMetricSource metricSource : metricSources) {
            if (!(metricSource instanceof IndexMetricSource)) continue;
            IndexMetricSource indexMetricSource = (IndexMetricSource)metricSource;
            partitions.add(indexMetricSource.getMetricPartition());
        }
        return partitions;
    }
}

