/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

record RawMethodLastTestedValue(boolean latest, @Nullable CommitDescriptor uploadOrMergeCommit) {
    public static final RawMethodLastTestedValue LATEST = new RawMethodLastTestedValue(true, null);
    private static final byte FLAG_LATEST = 1;
    private static final byte FLAG_COMMIT = 2;
    private static final int FLAGS_BYTES = 1;
    private static final int COMMIT_BYTES = 12;

    static void extractStringIds(byte[] bytes, Set<Integer> stringIds) {
        if (bytes == null || bytes.length <= 1) {
            return;
        }
        byte flags = bytes[0];
        if ((flags & 2) != 0) {
            int branchNameId = ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)9);
            stringIds.add(branchNameId);
        }
    }

    static RawMethodLastTestedValue fromByteArray(byte @NonNull [] bytes, Map<Integer, String> unabbreviationMap) {
        byte flags = bytes[0];
        boolean latest = (flags & 1) != 0;
        int offset = 1;
        CommitDescriptor commit = null;
        if ((flags & 2) != 0) {
            long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])bytes, (int)offset);
            String branchName = unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(offset + 8)));
            commit = new CommitDescriptor(branchName, timestamp);
        }
        return new RawMethodLastTestedValue(latest, commit);
    }

    static byte @NonNull [] appendMergeCommit(byte @Nullable [] rawUploadCommit, CommitDescriptor mergeCommit, StorageStringAbbreviator stringAbbreviator) throws StorageException {
        boolean isLatest = false;
        if (rawUploadCommit != null) {
            byte flags = rawUploadCommit[0];
            isLatest = (flags & 1) != 0;
        }
        return RawMethodLastTestedValue.toByteArray(isLatest, mergeCommit, stringAbbreviator);
    }

    byte[] toByteArray(StorageStringAbbreviator stringAbbreviator) throws StorageException {
        return RawMethodLastTestedValue.toByteArray(this.latest, this.uploadOrMergeCommit, stringAbbreviator);
    }

    private static byte @NonNull [] toByteArray(boolean isLatest, CommitDescriptor commit, StorageStringAbbreviator stringAbbreviator) throws StorageException {
        byte flags = 0;
        if (isLatest) {
            flags = (byte)(flags | 1);
        }
        if (commit == null) {
            return new byte[]{flags};
        }
        flags = (byte)(flags | 2);
        byte[] result = new byte[13];
        result[0] = flags;
        ByteArrayUtils.putLongIntoByteArray((byte[])result, (int)1, (long)commit.getTimestamp());
        ByteArrayUtils.putIntIntoByteArray((byte[])result, (int)9, (int)stringAbbreviator.abbreviate(commit.getBranchName()));
        return result;
    }
}

