/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.UserResolvedFindingBlacklistInfo;
import com.teamscale.index.task.ETaskStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.jspecify.annotations.Nullable;

@NoIndexValueClass
public class ExtendedTrackedFinding
extends TrackedFinding {
    private static final long serialVersionUID = 1L;
    private static final String TYPE_NAME_PROPERTY = "typeName";
    private static final String TASKS_BY_STATUS_PROPERTY = "tasksByStatus";
    private static final String BLACKLIST_INFO_PROPERTY = "blacklistInfo";
    @JsonProperty(value="typeName")
    private final String typeName;
    @JsonProperty(value="tasksByStatus")
    private ListMap<ETaskStatus, SimpleTask> tasksByStatus;
    @JsonProperty(value="blacklistInfo")
    private @Nullable UserResolvedFindingBlacklistInfo blacklistInfo;

    @JsonCreator
    public ExtendedTrackedFinding(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="groupName") String groupName, @JsonProperty(value="categoryName") String categoryName, @JsonProperty(value="message") String message, @JsonProperty(value="location") ElementLocation location, @JsonProperty(value="id") String id, @JsonProperty(value="birth") CommitDescriptor birth, @JsonProperty(value="death") CommitDescriptor death, @JsonProperty(value="blacklistInfo") @Nullable UserResolvedFindingBlacklistInfo blacklistInfo, @JsonProperty(value="codeScopeName") CodeScopeName codeScopeName) {
        super(groupName, categoryName, message, location, id, birth, death, codeScopeName);
        this.typeName = typeName;
        this.blacklistInfo = blacklistInfo;
    }

    public ExtendedTrackedFinding(TrackedFinding other, String typeName, ListMap<ETaskStatus, SimpleTask> tasksByStatus, @Nullable UserResolvedFindingBlacklistInfo blacklistInfo) {
        super(other);
        this.typeName = typeName;
        this.tasksByStatus = tasksByStatus;
        this.blacklistInfo = blacklistInfo;
    }

    public Integer getNumberOfTasks() {
        return ((List)this.tasksByStatus.getValues()).size();
    }

    public Optional<FindingBlacklistInfo> getBlacklistInfo() {
        return Optional.ofNullable(this.blacklistInfo).map(UserResolvedFindingBlacklistInfo::getInfo);
    }

    @JsonGetter(value="properties")
    @Schema(additionalProperties=Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION, oneOf={String.class, Number.class})
    public Map<String, Object> getProperties() {
        if (this.blacklistInfo == null || this.blacklistInfo.getInfo() == null) {
            return super.getProperties();
        }
        HashMap<String, Object> enhancedProperties = new HashMap<String, Object>(super.getProperties());
        EFindingBlacklistType findingBlacklistType = this.blacklistInfo.getInfo().getType();
        enhancedProperties.put(findingBlacklistType.getBlacklistDateFindingProperty(), this.blacklistInfo.getInfo().getTimestamp());
        enhancedProperties.put(findingBlacklistType.getBlacklistRationaleFindingProperty(), this.blacklistInfo.getInfo().getRationale());
        enhancedProperties.put(findingBlacklistType.getTolerationUserFindingProperty(), this.blacklistInfo.getInfo().getUser());
        return CollectionUtils.asUnmodifiable(enhancedProperties);
    }

    public Map<String, Object> getPropertiesWithoutBlacklistProperties() {
        return super.getProperties();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedTrackedFinding that = (ExtendedTrackedFinding)((Object)o);
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.tasksByStatus, that.tasksByStatus) && Objects.equals(this.blacklistInfo, that.blacklistInfo);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeName, this.tasksByStatus, this.blacklistInfo);
    }

    public record SimpleTask(@JsonProperty(value="id") Integer id, @JsonProperty(value="subject") String subject) {
    }
}

