/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Check(id="cqse-do-not-repeat-class-name-in-members", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotRepeatClassNameInMembersCheck
extends CheckImplementationBase {
    private static final Set<String> CONSTRUCTOR_SUB_TYPE_NAMES = Set.of("constructor", "constructor declaration", "static constructor", "destructor", "destructor declaration");

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!type.getSubtype().equals("class")) continue;
            for (ShallowEntity child : type.getChildren()) {
                if (child.getType() == EShallowEntityType.ATTRIBUTE) {
                    this.processEntity(child);
                }
                if (child.getType() != EShallowEntityType.METHOD || CONSTRUCTOR_SUB_TYPE_NAMES.contains(child.getSubtype())) continue;
                this.processEntity(child);
            }
        }
    }

    private static String getLowerCaseName(ShallowEntity entity) {
        return entity.getName().toLowerCase();
    }

    private void processEntity(ShallowEntity entity) {
        CCSMAssert.isNotNull((Object)entity.getParent());
        if (entity.getName() != null && entity.getParent().getName() != null && DoNotRepeatClassNameInMembersCheck.getLowerCaseName(entity).contains(DoNotRepeatClassNameInMembersCheck.getLowerCaseName(entity.getParent()))) {
            this.buildFinding("Do not repeat the name of a class in its members", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

