/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.SubTypeNames;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-selection-and-iteration-compound-body", languages={ELanguage.ADA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.XTEND, ELanguage.RUST, ELanguage.PHP, ELanguage.OPEN_CL, ELanguage.GOSU, ELanguage.GROOVY, ELanguage.DELPHI, ELanguage.OSCRIPT, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SelectionAndIterationCompoundBodyCheck
extends CheckImplementationBase {
    @CheckOption(name="Allow missing braces for these statements within the body of the conditional/loop", description="Define keywords that allow conditional statements and loops without braces if they follow on the same line. If no keywords are specified, any missing braces for conditionals and loops will be reported. Specify keywords separated by commas. E.g. \"return,break\".")
    private Set<String> allowedKeywordsInIfs = new HashSet<String>();
    private static final Set<ETokenType> NEGATIVE_START_SET = EnumSet.of(ETokenType.LPAREN, ETokenType.IDENTIFIER);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!SubTypeNames.IF_CONDITION_SUB_TYPE_NAMES.contains(statement.getSubtype()) && !SubTypeNames.LOOP_SUB_TYPE_NAMES.contains(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!entity.hasChildren()) {
            return;
        }
        ShallowEntity firstEntity = (ShallowEntity)entity.getChildren().get(0);
        if (firstEntity.getType() == EShallowEntityType.META) {
            return;
        }
        if (firstEntity.getRelativeStartTokenIndex() == 0) {
            return;
        }
        UnmodifiableList startTokens = entity.ownStartTokens();
        CCSMAssert.isTrue((0 < startTokens.size() ? 1 : 0) != 0, (String)"No tokens to check.");
        if (NEGATIVE_START_SET.contains(((IToken)startTokens.get(0)).getType())) {
            return;
        }
        if (!this.allowedKeywordsInIfs.isEmpty() && entity.getChildren().size() == 1 && this.checkSpecifiedKeywords(firstEntity)) {
            return;
        }
        if (SelectionAndIterationCompoundBodyCheck.checkLastTokenType((List<IToken>)startTokens, EnumSet.of(ETokenType.RPAREN, ETokenType.ELSE, ETokenType.DO))) {
            this.buildFinding(SelectionAndIterationCompoundBodyCheck.getStatementName((List<IToken>)startTokens) + " statement without braces", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }

    private static boolean checkLastTokenType(List<IToken> tokens, EnumSet<ETokenType> types) {
        return types.contains(tokens.get(tokens.size() - 1).getType());
    }

    private boolean checkSpecifiedKeywords(ShallowEntity entity) {
        return !entity.hasChildren() && this.allowedKeywordsInIfs.contains(entity.getName()) && SelectionAndIterationCompoundBodyCheck.isInSameLineAsParent(entity);
    }

    private static boolean isInSameLineAsParent(ShallowEntity entity) {
        return entity.getParent().getStartLine() == entity.getStartLine() && entity.getStartLine() == entity.getEndLine();
    }

    private static String getStatementName(List<IToken> tokens) {
        IToken firstToken = tokens.get(0);
        if (tokens.size() > 1) {
            IToken secondToken = tokens.get(1);
            if (firstToken.getType() == ETokenType.ELSE && secondToken.getType() == ETokenType.IF) {
                return secondToken.getText();
            }
        }
        return firstToken.getText();
    }
}

