/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cobol;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CobolAvoidDiscouragedStatementsCheckBase
extends CheckImplementationBase {
    private List<ETokenType[]> discouragedSequences = Arrays.asList(new ETokenType[0][]);

    protected CobolAvoidDiscouragedStatementsCheckBase(List<ETokenType[]> discouragedSequences) {
        this.discouragedSequences = discouragedSequences;
    }

    public void execute() throws CheckException {
        UnmodifiableList tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        for (ETokenType[] discouragedSequence : this.discouragedSequences) {
            int findingIndex = -1;
            while ((findingIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)(findingIndex + 1), (ETokenType[])discouragedSequence)) != -1) {
                List<IToken> statementTokens = tokens.subList(findingIndex, findingIndex + discouragedSequence.length);
                this.createDiscouragedStatementFinding(statementTokens);
            }
        }
    }

    protected abstract void createDiscouragedStatementFinding(List<IToken> var1) throws CheckException;
}

