/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-do-not-compare-optional-with-null", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class DoNotCompareOptionalWithNullCheck
extends CheckImplementationBase {
    private static final ITokenMatcher COMPARE_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.NOTEQ});

    public void execute() throws CheckException {
        List statementsInMethod = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD, method -> true, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statementInMethod : statementsInMethod) {
            this.processEntity(statementInMethod);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List compareIndices = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)COMPARE_OPERATORS);
        Iterator iterator = compareIndices.iterator();
        while (iterator.hasNext()) {
            IToken rightOperand;
            int compareIndex = (Integer)iterator.next();
            IToken leftOperand = (IToken)tokens.get(compareIndex - 1);
            if (this.nullComparisonCheck(entity, leftOperand, rightOperand = (IToken)tokens.get(compareIndex + 1))) {
                this.buildFinding("Instance of Optional `" + leftOperand.getText() + "` should not be compared to `null`", this.buildLocation().betweenTokens(leftOperand, rightOperand)).createAndStore();
                continue;
            }
            if (!this.nullComparisonCheck(entity, rightOperand, leftOperand)) continue;
            this.buildFinding("Instance of Optional `" + rightOperand.getText() + "` should not be compared to `null`", this.buildLocation().betweenTokens(leftOperand, rightOperand)).createAndStore();
        }
    }

    private boolean nullComparisonCheck(ShallowEntity entity, IToken firstOperand, IToken secondOperand) throws CheckException {
        ScopedTypeLookup types = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        String firstOperandName = firstOperand.getText();
        ETokenType secondOperandType = secondOperand.getType();
        return types.containsVariable(firstOperandName) && types.getTypeInfo(firstOperandName).getTypeNameWithoutGenericTypeParameter().equals("Optional") && secondOperandType == ETokenType.NULL_LITERAL;
    }
}

