/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-same-name-as-constructor", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SameNameAsConstructorCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            for (ShallowEntity child : type.getChildren()) {
                if (child.getType() != EShallowEntityType.METHOD || !child.getSubtype().equals("method") && !child.getSubtype().equals("static method")) continue;
                this.processEntity(child);
            }
        }
    }

    private void processEntity(ShallowEntity entity) {
        String methodName = entity.getName();
        if (methodName != null && methodName.equals(entity.getParent().getName())) {
            this.buildFinding("Method `" + methodName + "` should not be named like the constructor", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

