/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.jmaab.jc_0245", languages={ELanguage.SIMULINK})
public class SimulinkSignalAndBusNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Minimum length of bus names", description="The minimum number of characters for names of signals and buses.")
    private int minimumLength = 0;
    @CheckOption(name="Maximum length of bus names", description="The maximum number of characters for names of signals and buses.")
    private int maximumLength = 63;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkLine line : model.getContainedLinesRecursively(false, false)) {
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, this.minimumLength, this.maximumLength, line.getName().orElse(null), "Signal/Bus", this.buildLocation().forSimulinkLine(line));
        }
    }
}

