/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Check(id="cqse.hism.hisl_0022", languages={ELanguage.SIMULINK})
public class SimulinkDataTypeOfIndexSignalCheck
extends CheckImplementationBase {
    private static final Set<String> INDEX_SIGNAL_BLOCKS = Set.of("Assignment", "LookupNDDirect", "MultiPortSwitch", "Selector", "Interpolation_n-D");
    private static final String INDEX_SIGNAL_FINDING_MESSAGE = "Inappropriate data type for index signals";
    private static final String INDEX_VARIABLE_FINDING_MESSAGE = "Inappropriate data type for index variables";
    private static final FindingPropertyList INDEX_SIGNAL_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider changing the data type of index signals to an integer or enum.");
    private static final FindingPropertyList INDEX_VARIABLE_RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider changing the data type of index variables to an integer or enum.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            this.checkIndexVariablesOfChart(chart, model);
        }
        SimulinkResolvedDataTypes resolvedDataTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (resolvedDataTypes == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, INDEX_SIGNAL_BLOCKS, (boolean)false, (boolean)false)) {
            this.checkIndexSignalsOfBlockPorts(block, resolvedDataTypes);
        }
    }

    private void checkIndexVariablesOfChart(StateflowChart chart, SimulinkModel model) {
        String label;
        if (!StateflowUtils.hasActionLanguageC((StateflowChart)chart)) {
            return;
        }
        for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
            label = transition.getLabel();
            if (!SimulinkDataTypeOfIndexSignalCheck.labelContainsViolatingIndexVariable(chart, label, model)) continue;
            this.context.buildFinding(INDEX_VARIABLE_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(INDEX_VARIABLE_RECOMMENDED_ACTION).createAndStore();
        }
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            label = node.getParameter("labelString");
            if (label == null || !SimulinkDataTypeOfIndexSignalCheck.labelContainsViolatingIndexVariable(chart, label, model)) continue;
            this.context.buildFinding(INDEX_VARIABLE_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(INDEX_VARIABLE_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean labelContainsViolatingIndexVariable(@NonNull StateflowChart chart, @Nullable String label, @NonNull SimulinkModel model) {
        if (label == null) {
            return false;
        }
        HashSet<String> indexVariableDataTypes = new HashSet<String>();
        List tokens = ScannerUtils.getTokens((String)label, (ELanguage)ELanguage.CPP, (String)model.getUniformPath());
        List arrayAccessIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence((List)tokens, (int)0, (int)(tokens.size() - 1), (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.RBRACK});
        for (Integer index : arrayAccessIndices) {
            StateflowUtils.getDataTypeOfDataName((StateflowChart)chart, (String)((IToken)tokens.get(index + 1)).getText()).ifPresent(indexVariableDataTypes::add);
        }
        return SimulinkDataTypeOfIndexSignalCheck.containsViolatingDataType(indexVariableDataTypes);
    }

    private void checkIndexSignalsOfBlockPorts(SimulinkBlock block, SimulinkResolvedDataTypes resolvedDataTypes) {
        Set<String> indexPorts = SimulinkDataTypeOfIndexSignalCheck.getIndexSignalPortNumbers(block);
        Set indexInputDataTypes = resolvedDataTypes.getInputDataTypes(block, indexPorts);
        if (SimulinkDataTypeOfIndexSignalCheck.missingIndexSignal(block, indexPorts) || SimulinkDataTypeOfIndexSignalCheck.containsViolatingDataType(indexInputDataTypes)) {
            this.context.buildFinding(INDEX_SIGNAL_FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(INDEX_SIGNAL_RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean missingIndexSignal(SimulinkBlock block, Set<String> signalIndexPortIndex) {
        return signalIndexPortIndex.stream().map(arg_0 -> ((SimulinkBlock)block).getInPort(arg_0)).anyMatch(inPort -> SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort) == null);
    }

    private static boolean containsViolatingDataType(Set<String> dataTypes) {
        for (String dataType : dataTypes) {
            if (!SimulinkDataTypeUtils.isFloatingPointDataType((String)dataType)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getIndexSignalPortNumbers(SimulinkBlock block) {
        String blockType;
        switch (blockType = block.getType()) {
            case "MultiPortSwitch": {
                return Set.of("1");
            }
            case "Selector": 
            case "Assignment": {
                if (!block.getParameter("IndexOptions").contains("port")) {
                    return Collections.emptySet();
                }
                return Set.of(String.valueOf(block.getInPorts().size()));
            }
            case "LookupNDDirect": {
                return SimulinkDataTypeOfIndexSignalCheck.getIndexSignalPortNumbersForDirectLookup(block);
            }
            case "Interpolation_n-D": {
                if ("on".equals(block.getParameter("RequireIndexFractionAsBus"))) {
                    return Collections.emptySet();
                }
                return SimulinkDataTypeOfIndexSignalCheck.getIndexSignalPortNumbersForInterpolation(block);
            }
        }
        return CollectionUtils.emptySet();
    }

    private static Set<String> getIndexSignalPortNumbersForDirectLookup(SimulinkBlock block) {
        int relevantInPorts = block.getInPorts().size();
        if ("on".equals(block.getParameter("TableIsInput"))) {
            --relevantInPorts;
        }
        HashSet<String> indexSignalPortNumbers = new HashSet<String>();
        while (relevantInPorts > 0) {
            indexSignalPortNumbers.add(Integer.toString(relevantInPorts--));
        }
        return indexSignalPortNumbers;
    }

    private static Set<String> getIndexSignalPortNumbersForInterpolation(SimulinkBlock block) {
        int tableDimensions = Integer.parseInt(block.getParameter("NumberOfTableDimensions"));
        int subTableDimensions = Integer.parseInt(block.getParameter("NumSelectionDims"));
        HashSet<String> indexSignalPortNumbers = new HashSet<String>();
        for (int i = 0; i < tableDimensions - subTableDimensions; ++i) {
            indexSignalPortNumbers.add(Integer.toString(2 * i + 1));
        }
        return indexSignalPortNumbers;
    }
}

