/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.util.SimulinkSampleTimeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.design.MergeBlkUsage", languages={ELanguage.SIMULINK})
public class SimulinkMergeBlockParametersCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_RUNTIME_DIAGNOSTIC_SETTING = FindingPropertyList.singleton((String)"Recommended Action", (String)"In the Configuration Parameters dialog box, set the 'Detect multiple driving blocks executing at the same time step' option to 'error'.");
    private static final String FINDING_RUNTIME_DIAGNOSTIC_SETTING = "The run-time diagnostic setting is incorrect for this model";
    private static final FindingPropertyList RECOMMENDED_ACTION_UNSPECIFIED_INITIAL_OUTPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Verify that the behaviour of this root Merge block is acceptable before migrating to simplified initialization mode. If it is not acceptable, specify an explicit value for the 'Initial output' parameter of this root Merge block. (A root Merge block is a Merge block with an output port that does not connect to another Merge block.)");
    private static final String FINDING_UNSPECIFIED_INITIAL_OUTPUT = "The 'Initial output' parameter is not explicitly specified (i.e. is set to '[]') for this root Merge block, so the Merge block uses the default initial value of the output data type as the 'Initial output' value";
    private static final FindingPropertyList RECOMMENDED_ACTION_NONZERO_INPUT_PORT_OFFSET = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the 'Allow unequal port widths' parameter to 'off' for this Merge block. Merge blocks shall only be used for signal elements requiring true merging; other elements shall be combined with merged elements contiguously using the Concatenate block.");
    private static final String FINDING_NONZERO_INPUT_PORT_OFFSET = "The 'Allow unequal port widths' parameter is set to 'on' for this Merge block";
    private static final FindingPropertyList RECOMMENDED_ACTION_UNCONNECTED_INPUTS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the 'Number of inputs' parameter of the Merge block to the number of Merge block inputs and connect each input to a signal.");
    private static final String FINDING_UNCONNECTED_INPUTS = "The Merge block has unconnected inputs";
    private static final FindingPropertyList RECOMMENDED_ACTION_NON_CONDITIONALLY_EXECUTED_SUBSYSTEM_INPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect each Merge block input directly to a conditionally executed subsystem.");
    private static final String FINDING_NON_CONDITIONALLY_EXECUTED_SUBSYSTEM_INPUT = "The Merge block has inputs that are driven directly by a block that is not a conditionally executed subsystem (and not another Merge block, in case of chained Merge blocks)";
    private static final FindingPropertyList RECOMMENDED_ACTION_INCONSISTENT_INPUT_SAMPLE_TIME = FindingPropertyList.singleton((String)"Recommended Action", (String)"Modify the sample times of the input signals to the Merge block so that they all have the same sample time.");
    private static final String FINDING_INCONSISTENT_INPUT_SAMPLE_TIME = "The input signals to this Merge block have different sample times";
    private static final FindingPropertyList RECOMMENDED_ACTION_INPUT_PORTS_WITH_SAME_SOURCE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Connect each Merge block input directly to a separate conditionally executed subsystem.");
    private static final String FINDING_INPUT_PORTS_WITH_SAME_SOURCE = "Two or more input signals of the Merge block are directly connected to the same conditionally executed subsystem";
    private static final Set<String> MERGE_BLOCK_TYPES = Set.of("Merge");

    public void execute() {
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::executeSubchecks);
    }

    private void executeSubchecks(SimulinkBlock system) {
        if (!"Classic".equals(system.getParameter("UnderspecifiedInitializationDetection"))) {
            return;
        }
        this.checkRuntimeDiagnosticSetting(system);
        for (SimulinkBlock mergeBlock : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)system, MERGE_BLOCK_TYPES, (boolean)false, (boolean)false)) {
            this.checkRootMergeBlocksWithUnspecifiedInitialOutputValue(mergeBlock);
            this.checkNonzeroInputPortOffset(mergeBlock);
            this.checkWrongInputs(mergeBlock);
            this.checkInconsistentInputSampleTimes(mergeBlock);
            this.checkMultipleInputPortsWithSameSource(mergeBlock);
        }
    }

    private void checkRuntimeDiagnosticSetting(SimulinkBlock system) {
        if (!"Error".equalsIgnoreCase(system.getParameter("MergeDetectMultiDrivingBlocksExec"))) {
            this.context.buildFinding(FINDING_RUNTIME_DIAGNOSTIC_SETTING, (ElementLocation)this.buildLocation().forSimulinkBlock(system)).addFindingProperties(RECOMMENDED_ACTION_RUNTIME_DIAGNOSTIC_SETTING).createAndStore();
        }
    }

    private void checkRootMergeBlocksWithUnspecifiedInitialOutputValue(SimulinkBlock mergeBlock) {
        if (SimulinkMergeBlockParametersCheck.isRootMergeBlock(mergeBlock) && mergeBlock.getParameter("InitialOutput").equals("[]")) {
            this.context.buildFinding(FINDING_UNSPECIFIED_INITIAL_OUTPUT, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_UNSPECIFIED_INITIAL_OUTPUT).createAndStore();
        }
    }

    private static boolean isRootMergeBlock(SimulinkBlock mergeBlock) {
        return mergeBlock.getOutPorts().stream().allMatch(outPort -> SimulinkUtils.getConnectedBlocks((SimulinkOutPort)outPort).stream().noneMatch(block -> block != null && block.isOfType("Merge")));
    }

    private void checkNonzeroInputPortOffset(SimulinkBlock mergeBlock) {
        if (mergeBlock.getParameter("AllowUnequalInputPortWidths").equals("on")) {
            this.context.buildFinding(FINDING_NONZERO_INPUT_PORT_OFFSET, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_NONZERO_INPUT_PORT_OFFSET).createAndStore();
        }
    }

    private void checkWrongInputs(SimulinkBlock mergeBlock) {
        boolean hasUnconnectedInput = false;
        boolean hasNonConditionallyExecutedSubsystem = false;
        for (SimulinkInPort inPort : mergeBlock.getInPorts()) {
            if (!inPort.isConnected()) {
                hasUnconnectedInput = true;
                continue;
            }
            if (SimulinkMergeBlockParametersCheck.isValidBlockConnectedToInport(SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort))) continue;
            hasNonConditionallyExecutedSubsystem = true;
        }
        if (hasUnconnectedInput) {
            this.context.buildFinding(FINDING_UNCONNECTED_INPUTS, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_UNCONNECTED_INPUTS).createAndStore();
        }
        if (hasNonConditionallyExecutedSubsystem) {
            this.context.buildFinding(FINDING_NON_CONDITIONALLY_EXECUTED_SUBSYSTEM_INPUT, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_NON_CONDITIONALLY_EXECUTED_SUBSYSTEM_INPUT).createAndStore();
        }
    }

    private void checkInconsistentInputSampleTimes(SimulinkBlock mergeBlock) {
        Set sampleTimes = mergeBlock.getInPorts().stream().map(SimulinkUtils::getConnectedBlock).filter(Objects::nonNull).map(SimulinkSampleTimeUtils::getInheritedSampleTime).filter(sampleTime -> !sampleTime.equals("")).collect(Collectors.toSet());
        if (sampleTimes.size() > 1) {
            this.context.buildFinding(FINDING_INCONSISTENT_INPUT_SAMPLE_TIME, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_INCONSISTENT_INPUT_SAMPLE_TIME).createAndStore();
        }
    }

    private void checkMultipleInputPortsWithSameSource(SimulinkBlock mergeBlock) {
        List prevBlocks = mergeBlock.getInPorts().stream().map(SimulinkUtils::getConnectedBlock).filter(SimulinkMergeBlockParametersCheck::isValidBlockConnectedToInport).collect(Collectors.toList());
        Set prevBlocksUnique = Set.copyOf(prevBlocks);
        if (prevBlocksUnique.size() < prevBlocks.size()) {
            this.context.buildFinding(FINDING_INPUT_PORTS_WITH_SAME_SOURCE, (ElementLocation)this.buildLocation().forSimulinkBlock(mergeBlock)).addFindingProperties(RECOMMENDED_ACTION_INPUT_PORTS_WITH_SAME_SOURCE).createAndStore();
        }
    }

    private static boolean isValidBlockConnectedToInport(SimulinkBlock block) {
        return block != null && (SimulinkUtils.isConditionalSubsystem((SimulinkBlock)block) || block.isOfType("Merge"));
    }
}

