/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-appropriate-units", languages={ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS})
public class AppropriateUnitsCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Appropriate Units";
    @CheckOption(name="Appropriate Units - Rules", description="The list of rules that specify for which *item types* and which *item fields* this check is executed.\nMultiple rules are separated by new-lines.\n<p>\nA rule has the format:\n\n`<itemTypes> -> <fieldNames>`\n\n`<itemTypes>`: a `|` separated list of item types.<br>\nThis check is executed for all listed types.\nA type must be specified as full name (e.g., `Requirement`)\tor its abbreviation (e.g., `REQ`).\nThe special placeholder `ANY` can be used in place of a concrete type list to execute this check irrespective of the item types.\n\n`<fieldNames>`: a `|` separated list of item fields.<br>\nThis check is executed on all listed fields that are present in any of the item types of the same rule.\nThe special placeholder `ALL` can be used in place of a concrete field list to execute this check on all fields.\n\nHere are some example rules:\n+ `Requirement -> Description`<br>\n  The check is executed on the `Description` field of `Requirement` items.\n+ `REQ | WI -> Description | Status`<br>\n  The check is executed on the `Description` and `Status` fields of `REQ` and `WI` items.\n+ `ANY -> Description`<br>\n  The check is executed on the `Description` field of all items irrespective of their types.\n+ `REQ -> ALL`<br>\n  The check is executed on all fields of `REQ` items.\n+ `ANY -> ALL`<br>\n  The check is executed on all fields all items irrespective of their types.\n", multilineText=true)
    private Set<String> rawAppropriateUnitsRules = Collections.emptySet();
    @CheckOption(name="Appropriate Units - Units", description="A set of appropriate units that the check will match against.\n")
    private Set<String> units = Set.of("%", "A", "Bq", "C", "cd", "ch", "cm", "cwt", "day", "dBm", "eV", "F", "fl oz", "ft", "ft/s", "furlong", "g", "gal", "Gy", "H", "h", "hr", "Hz", "in", "J", "K", "kat", "kg", "km", "km/h", "kn", "lb", "lm", "lx", "m", "m/s", "mg", "mi", "min", "mm", "mol", "mph", "ms", "N", "nmi", "ns", "oz", "Pa", "rad", "S", "s", "sec", "sr", "st", "Sv", "T", "t", "thou", "ton", "V", "W", "Wb", "wk", "yd", "\u00b0C", "\u00b0F", "\u03a9");
    @CheckOption(name="Appropriate Units - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and\nnot included in the detection of this check.\nFor example, the regex `\".*?\"` ignores text that is enclosed in double quotes.\n")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'");
    private final Set<TypedSetRule<String>> parsedAppropriateUnitsRules = new HashSet<TypedSetRule<String>>();
    private static final TypedSetRule.Parser<String> PARSER = new TypedSetRule.Parser<String>().withValueParser(ParsableRule.RuleParser.TO_STRING);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\b\\d+(\\.\\d+)?\\b");
    private Pattern compiledIgnorePattern;
    private Pattern compiledAppropriateUnitPattern;

    public AppropriateUnitsCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        StringJoiner combinedIgnorePattern = new StringJoiner(")|(", "(", ")");
        this.ignorePatterns.forEach(combinedIgnorePattern::add);
        this.compiledIgnorePattern = Pattern.compile(combinedIgnorePattern.toString());
        this.compiledAppropriateUnitPattern = Pattern.compile("\\d+\\s*(" + String.join((CharSequence)"|", this.units) + ")");
        for (String rawRule : this.rawAppropriateUnitsRules) {
            this.parsedAppropriateUnitsRules.add((TypedSetRule<String>)PARSER.parse(rawRule));
        }
    }

    @Override
    protected void execute(SpecItem workItem) throws CheckException {
        for (TypedSetRule<String> rule : this.parsedAppropriateUnitsRules) {
            if (!rule.matches(workItem)) continue;
            if (rule.values.contains("ALL")) {
                List fieldNames = this.getDescriber((TeamscaleIssue)workItem).getNonTechnicalKeys((TeamscaleIssue)workItem);
                for (String field : fieldNames) {
                    this.checkViolation(workItem, field);
                }
                continue;
            }
            for (String field : rule.values) {
                this.checkViolation(workItem, field);
            }
        }
    }

    private void checkViolation(SpecItem item, String field) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldValue = valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED);
        if (StringUtils.isEmpty((String)fieldValue)) {
            return;
        }
        String filteredField = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)this.compiledIgnorePattern, (String)fieldValue);
        filteredField = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)this.compiledAppropriateUnitPattern, (String)filteredField);
        Matcher numberMatcher = NUMBER_PATTERN.matcher(filteredField);
        while (numberMatcher.find()) {
            this.buildFinding(AppropriateUnitsCheck.buildFindingMessage(numberMatcher.group()), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW))).addFindingProperties(AppropriateUnitsCheck.buildProperties(item, field, numberMatcher.group())).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, String expression) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Expression", (Object)expression);
        return properties;
    }

    public static String buildFindingMessage(String expression) {
        return "Prefer using numbers with appropriate units: '%s'".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)expression));
    }
}

