/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.sonarsource.sonarlint.core.telemetry.LocalDateAdapter;
import org.sonarsource.sonarlint.shaded.com.google.gson.TypeAdapter;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonReader;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonWriter;

public class LocalDateTimeAdapter
extends TypeAdapter<LocalDateTime> {
    @Override
    public void write(JsonWriter jsonWriter, LocalDateTime localDateTime) throws IOException {
        jsonWriter.beginObject().name("date");
        new LocalDateAdapter().nullSafe().write(jsonWriter, localDateTime.toLocalDate());
        jsonWriter.name("time").beginObject().name("hour").value(localDateTime.getHour()).name("minute").value(localDateTime.getMinute()).name("second").value(localDateTime.getSecond()).name("nano").value(localDateTime.getNano()).endObject().endObject();
    }

    @Override
    public LocalDateTime read(JsonReader jsonReader) throws IOException {
        LocalDate localDate = null;
        LocalTime localTime = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "date": {
                    localDate = new LocalDateAdapter().read(jsonReader);
                    break;
                }
                case "time": {
                    localTime = LocalDateTimeAdapter.readTime(jsonReader);
                    break;
                }
            }
        }
        jsonReader.endObject();
        if (localDate == null || localTime == null) {
            throw new IllegalStateException("Unable to parse LocalDateTime");
        }
        return LocalDateTime.of(localDate, localTime);
    }

    private static LocalTime readTime(JsonReader jsonReader) throws IOException {
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nano = 0;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "hour": {
                    hour = jsonReader.nextInt();
                    break;
                }
                case "minute": {
                    minute = jsonReader.nextInt();
                    break;
                }
                case "second": {
                    second = jsonReader.nextInt();
                    break;
                }
                case "nano": {
                    nano = jsonReader.nextInt();
                    break;
                }
            }
        }
        jsonReader.endObject();
        return LocalTime.of(hour, minute, second, nano);
    }
}

