/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.matcher;

import eu.cqse.check.framework.matcher.AllLowercaseMatcher;
import eu.cqse.check.framework.matcher.AndTokenMatcher;
import eu.cqse.check.framework.matcher.NegatedTokenMatcher;
import eu.cqse.check.framework.matcher.NeverMatcher;
import eu.cqse.check.framework.matcher.OrTokenMatcher;
import eu.cqse.check.framework.matcher.PrefixMatcher;
import eu.cqse.check.framework.matcher.RegexMatcher;
import eu.cqse.check.framework.matcher.TokenClassTokenMatcher;
import eu.cqse.check.framework.matcher.TokenTextTokenMatcher;
import eu.cqse.check.framework.matcher.TokenTypeTokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.intellij.lang.annotations.Language;

@NoIndexValueClass(rationale="ETokenType and ETokenClass are in backup, but not any other ITokenMatcher implementation")
public interface ITokenMatcher {
    public boolean matches(IToken var1);

    public String humanReadable();

    default public ITokenMatcher or(ITokenMatcher ... further) {
        return ITokenMatcher.or(Stream.concat(Stream.of(this), Arrays.stream(further)).toList());
    }

    default public ITokenMatcher and(ITokenMatcher ... further) {
        return ITokenMatcher.and(Stream.concat(Stream.of(this), Arrays.stream(further)).toList());
    }

    default public ITokenMatcher negated() {
        return new NegatedTokenMatcher(this);
    }

    public static ITokenMatcher or(Collection<? extends ITokenMatcher> matchers) {
        if (matchers.size() == 1) {
            return matchers.iterator().next();
        }
        return new OrTokenMatcher(matchers);
    }

    public static ITokenMatcher and(Collection<? extends ITokenMatcher> matchers) {
        if (matchers.size() == 1) {
            return matchers.iterator().next();
        }
        return new AndTokenMatcher(matchers);
    }

    public static ITokenMatcher not(ITokenMatcher matcher) {
        return matcher.negated();
    }

    public static ITokenMatcher never() {
        return NeverMatcher.INSTANCE;
    }

    public static ITokenMatcher any() {
        return ITokenMatcher.never().negated();
    }

    default public ITokenMatcher except(ITokenMatcher ... matchers) {
        return this.and(ITokenMatcher.not(ITokenMatcher.or(Arrays.asList(matchers))));
    }

    public static ITokenMatcher anyOfType(ETokenType ... tokenTypes) {
        return ITokenMatcher.anyOfType(Arrays.asList(tokenTypes));
    }

    public static ITokenMatcher anyOfType(Collection<ETokenType> tokenTypes) {
        if (tokenTypes.size() == 1) {
            return tokenTypes.iterator().next();
        }
        return new TokenTypeTokenMatcher(tokenTypes);
    }

    public static ITokenMatcher noneOfType(ETokenType ... tokenTypes) {
        return ITokenMatcher.noneOfType(Arrays.asList(tokenTypes));
    }

    public static ITokenMatcher noneOfType(Collection<ETokenType> tokenTypes) {
        return ITokenMatcher.anyOfType(tokenTypes).negated();
    }

    public static ITokenMatcher anyOfClass(ETokenType.ETokenClass ... tokenClasses) {
        return ITokenMatcher.anyOfClass(Arrays.asList(tokenClasses));
    }

    public static ITokenMatcher anyOfClass(Collection<ETokenType.ETokenClass> tokenClasses) {
        if (tokenClasses.size() == 1) {
            return tokenClasses.iterator().next();
        }
        return new TokenClassTokenMatcher(tokenClasses);
    }

    public static ITokenMatcher noneOfClass(ETokenType.ETokenClass ... tokenClasses) {
        return ITokenMatcher.noneOfClass(Arrays.asList(tokenClasses));
    }

    public static ITokenMatcher noneOfClass(Collection<ETokenType.ETokenClass> tokenClasses) {
        return ITokenMatcher.anyOfClass(tokenClasses).negated();
    }

    public static ITokenMatcher hasText(String ... texts) {
        return ITokenMatcher.hasText(Arrays.asList(texts));
    }

    public static ITokenMatcher hasText(Collection<String> texts) {
        return new TokenTextTokenMatcher(texts);
    }

    public static ITokenMatcher uppercaseStart() {
        return ITokenMatcher.matchesRegex("[A-Z][A-Za-z0-9]*");
    }

    public static ITokenMatcher allLowercase() {
        return new AllLowercaseMatcher();
    }

    public static ITokenMatcher hasPrefix(String prefix) {
        return new PrefixMatcher(prefix);
    }

    public static ITokenMatcher matchesRegex(@Language(value="RegExp") String regex) {
        return ITokenMatcher.matchesRegex(Pattern.compile(regex));
    }

    public static ITokenMatcher matchesRegex(Pattern regexPattern) {
        return new RegexMatcher(regexPattern);
    }
}

