/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.configuration;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.conqat.lib.commons.concurrent.TaskWrappingExecutorService;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.jspecify.annotations.NonNull;

@ExportToTypeScript
public enum EFeatureToggle {
    NONE(""),
    CODE_USAGE_WIDGET("com.teamscale.feature-toggle.code-usage-widget"),
    BMW_COVERABLE_VOLUME_FILTER("bmw.teamscale.feature-toggle.coverable-volume-filter"),
    DISABLE_MEMORY_CHECK("com.teamscale.disable-memory-check"),
    DISABLE_COMMIT_CHART_WIDGET("com.teamscale.feature-toggle.disable-commit-chart-widget"),
    USE_COVERABLE_LINES_FROM_COVERAGE_REPORTS("com.teamscale.feature-toggle.use-coverable-lines-from-coverage-reports"),
    SKIP_CLASS_ATTRIBUTES_FOR_COVERAGE("com.teamscale.feature-toggle.skip-class-attributes-for-coverage"),
    ENABLE_MONITORING_UPLOAD("com.teamscale.enable-monitoring-uploads"),
    ENABLE_RAEX("com.teamscale.feature-toggle.raex"),
    ENABLE_DEV_MODE("com.teamscale.dev-mode"),
    DISABLE_UI_DEV_SERVER_MODE("com.teamscale.ui-dev-server-mode"),
    DISABLE_SIMULINK_DEPENDENCY_EXTRACTION("com.teamscale.simulink.dependency-extracion.disable"),
    INSTANCE_LABEL_OPTION_VISIBLE("com.teamscale.instance-label-option.visible"),
    DISABLE_DEFAULT_ANALYSIS_PROFILES_CREATION("com.teamscale.feature-toggle.disable-default-analysis-profiles-creation"),
    NO_WARN_ON_UNSAFE_ADMIN_USER("com.teamscale.feature-toggle.no-warn-on-unsafe-admin-user"),
    ENABLE_NORDEX_MODEL_ADVISOR_REPORT_ITEM("com.teamscale.feature-toggle.enable-nordex-model-advisor-report-item"),
    ENABLE_LOG_PERFORMANCE_DETAILS("com.teamscale.log_performance_details"),
    ENABLE_LOG_SCHEDULER_PERFORMANCE_DETAILS("com.teamscale.log_scheduler_performance_details"),
    ENABLE_GIT_AUTO_GC("com.teamscale.experimental.git-auto-gc"),
    ENABLE_APPLE_SPECIFIC_FEATURES("com.teamscale.customers.enable-apple-features"),
    ENABLE_TEST_MODE("com.teamscale.test-mode"),
    CLEANUP_ORPHANED_DATABASE_ENTIRES("com.teamscale.cleanup-database"),
    DISABLE_PERSISTENCE_MAINTENANCE_TRIGGER("com.teamscale.disable-persistence-maintenance"),
    GERRIT_PATCHSET_MAX_FILES_CHANGED_FILTER_COUNT("com.teamscale.gerrit.patchset-max-files"),
    DISABLE_DEAD_CONNECTOR_CHECK("com.teamscale.disable-dead-connector-check"),
    ENABLE_PREEMPTIVE_GIT_BASIC_AUTH("com.teamscale.enable-preemptive-git-basic-auth"),
    DISABLE_TEST_CASE_EXTRACTION("com.teamscale.disable-test-case-extraction"),
    ENABLE_LDAP_GROUP_AUTO_IMPORT("com.teamscale.enable-ldap-group-auto-import"),
    ENABLE_SCHEDULER_STORE_OVERLAP_DEBUG("com.teamscale.scheduler-store-overlap-debug"),
    DISABLE_WORKER_LOG_TRUNCATION("com.teamscale.disable-worker-log-truncation"),
    FORCE_FULL_EXTERNAL_UPLOAD_DELTA("com.teamscale.external-uploads.enable-full-delta"),
    DISABLE_VERSION_DISPLAY("com.teamscale.feature-toggle.disable-version-display"),
    DISABLE_FILE_SYSTEM_CONNECTOR("com.teamscale.feature-toggle.disable-file-system-connector"),
    SHOW_HIDDEN_LANGUAGES("com.teamscale.feature-toggle.show-hidden-languages"),
    CPP_DISABLE_REPARSE_ON_HEADER_CHANGE("com.teamscale.experimental.cpp-disable-reparse-on-header-change"),
    PRECOMMIT3_DISABLED("com.teamscale.diable_automatic_precommit_analysis"),
    DISABLE_AUTO_REPAIR_INCONSISTENT_COMMITS_ON_BACKUP_IMPORT("com.teamscale.index.backup.disable-auto-repair-backup-on-import"),
    DISABLE_COVERAGE_MERGING("com.teamscale.disable-coverage-merging"),
    PREFIX_CUSTOM_FINDING_DESCRIPTION("com.teamscale.feature-toggle.prefix-custom-finding-description"),
    ENABLE_INDEPENDENT_SONAR_LINT_ANALYSIS("com.teamscale.enable-independent-sonar-lint-analysis"),
    ENABLE_OUTSOURCED_CLANG_TIDY_ANALYSIS("com.teamscale.enable-outsourced-clang-tidy-analysis"),
    DISABLE_BULLSEYE_CONTROL_FLOW_PARSING("com.teamscale.disable-bullseye-control-flow-parsing"),
    DISABLE_BULLSEYE_COVERAGE_FALLBACK("com.teamscale.disable-bullseye-coverage-fallback"),
    AUDIT_FEATURES("com.teamscale.audit-features"),
    SVN_THOROUGH_AUTH_CHECK_SUPPORT("com.teamscale.enable-svn-thorough-auth-check-support"),
    ENABLE_PROJECT_WIZARD("com.teamscale.project_wizard.enabled"){

        @Override
        public boolean isEnabled() {
            return super.isEnabled() || ENABLE_DEV_MODE.isEnabled();
        }
    }
    ,
    ENABLE_MULTITHREADED_DB_READS("com.teamscale.multithreaded_db_reads.enabled"),
    AI_SUPPORT("com.teamscale.ai-support.enabled"),
    CHECK_AVAILABILITY_OF_ALL_TOOLS_ON_STARTUP("com.teamscale.check-availability-of-all-tools"),
    ENABLE_LEGACY_API("com.teamscale.legacy-api.enabled"),
    ENABLE_DEPRECATED_API("com.teamscale.deprecated-api.enabled"),
    PORTFOLIO_OVERVIEW("com.teamscale.portfolio.overview.enabled"),
    BMW_BUILD_SCRIPT_COMPATIBILITY_MODE("com.teamscale.bmw.build-script-compatibility"),
    ENABLE_MERGE_REQUEST_ANALYSIS_IN_PROGRESS_NOTIFICATION("com.teamscale.merge-request-analysis-in-progress-notification.enabled"),
    ENABLE_GITLAB_METRIC_BADGES("com.teamscale.gitlab-metric-badges.enabled"),
    ENABLE_GITLAB_PROJECT_CREATION_WIZARD("com.teamscale.gitlab-project-creation-wizard.enabled"){

        @Override
        public boolean isEnabled() {
            return super.isEnabled() || ENABLE_DEV_MODE.isEnabled();
        }
    }
    ,
    HIDE_METRIC_BADGES_WITH_ZERO_OR_NA("com.teamscale.merge-requests.metrics.hide-zero-or-na"),
    ENABLE_BINARY_SIZE_ELEMENT_FINDINGS_FILTERING("com.teamscale.enable-binary-size-element-finding-filtering"),
    ENABLE_SEMGREP_EXPERIMENTAl_MODE("com.teamscale.semgrep-experimental-mode"),
    ENABLE_DELETE_PARTITIONS_WITHOUT_UPLOADS_FOR_EXTERNAL_STORAGE("com.teamscale.enable-delete-partitions-storage-backend"),
    INDEX_TEST_IMPLEMENTATIONS_FOR_TEST_SELECTION("com.teamscale.test-selection.index-test-implementations"),
    CPPCHECK_PREMIUM_LICENSED("com.teamscale.cppcheck-premium-licensed"),
    ENABLE_CUSTOMER_SATISFACTION_DIALOG("com.teamscale.customer-satisfaction-dialog"),
    ENABLE_EXPERIMENTAL_BINARY_SIZE_CHECKS("com.teamscale.enable-experimental-checks.binary-size"),
    ENABLE_CLANG_TIDY_CPPCHECK_CROSS_FILE_ANALYSIS("com.teamscale.experimental.enable_cross_file_analysis"),
    DISABLE_CLANG_JNI_CHECKS("com.teamscale.disable-clang-jni-checks"),
    OVERWRITE_EXTERNAL_STORAGE("com.teamscale.external-storage.disable-user-configuration"),
    APPLE_AI_SUPPORT("com.teamscale.customers.enable-apple-ai-support"),
    ENABLE_BRANCH_POINTER_HISTORY_RECORDING("com.teamscale.branching.enable-branch-pointer-history");

    private static final InheritableThreadLocal<EnumSet<EFeatureToggle>> THREAD_LOCAL_PROPERTIES;
    private final String id;

    private EFeatureToggle(String id) {
        this.id = id;
    }

    public static Optional<EFeatureToggle> findById(String id) {
        return Arrays.stream(EFeatureToggle.values()).filter(toggle -> toggle.id.equals(id)).findFirst();
    }

    public static boolean isInUiDevServerMode() {
        return ENABLE_DEV_MODE.isEnabled() && !DISABLE_UI_DEV_SERVER_MODE.isEnabled();
    }

    public static boolean isInUiTestServerMode() {
        return ENABLE_DEV_MODE.isEnabled() && DISABLE_UI_DEV_SERVER_MODE.isEnabled();
    }

    private static EnumSet<EFeatureToggle> getAllEnabled() {
        return EnumSet.copyOf((EnumSet)THREAD_LOCAL_PROPERTIES.get());
    }

    private static void setAllEnabled(EnumSet<EFeatureToggle> featureToggles) {
        THREAD_LOCAL_PROPERTIES.set(featureToggles);
    }

    public static ExecutorService wrap(ExecutorService executorService) {
        return new TaskWrappingExecutorService(executorService, new TaskWrappingExecutorService.Wrapper(){

            public <T> @NonNull Callable<T> wrap(@NonNull Callable<T> callable) {
                return new FeatureTogglePropagatingCallable<T>(callable);
            }

            public <T> @NonNull Callable<T> unwrap(@NonNull Callable<T> callable) {
                return ((FeatureTogglePropagatingCallable)callable).delegate;
            }

            public @NonNull Runnable wrap(@NonNull Runnable runnable) {
                return new FeatureTogglePropagatingRunnable(runnable);
            }

            public @NonNull Runnable unwrap(@NonNull Runnable runnable) {
                return ((FeatureTogglePropagatingRunnable)runnable).delegate;
            }
        });
    }

    public boolean isEnabled() {
        return ((EnumSet)THREAD_LOCAL_PROPERTIES.get()).contains((Object)this);
    }

    public String getId() {
        return this.id;
    }

    public void setFeatureToggle(boolean value) {
        if (value) {
            ((EnumSet)THREAD_LOCAL_PROPERTIES.get()).add(this);
        } else {
            ((EnumSet)THREAD_LOCAL_PROPERTIES.get()).remove((Object)this);
        }
    }

    static {
        THREAD_LOCAL_PROPERTIES = new InheritableThreadLocal<EnumSet<EFeatureToggle>>(){

            @Override
            protected EnumSet<EFeatureToggle> initialValue() {
                return EnumUtils.safeCopyOf(Arrays.stream(EFeatureToggle.values()).filter(toggle -> Boolean.getBoolean(toggle.id)).toList(), EFeatureToggle.class);
            }

            @Override
            protected EnumSet<EFeatureToggle> childValue(EnumSet<EFeatureToggle> parentValue) {
                return EnumSet.copyOf(parentValue);
            }
        };
    }

    private static class FeatureTogglePropagatingCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;
        private final EnumSet<EFeatureToggle> callingThreadFeatureToggles;

        public FeatureTogglePropagatingCallable(Callable<T> delegate) {
            this.delegate = delegate;
            this.callingThreadFeatureToggles = EFeatureToggle.getAllEnabled();
        }

        @Override
        public T call() throws Exception {
            EnumSet<EFeatureToggle> inheritedFeatureToggles = EFeatureToggle.getAllEnabled();
            try {
                EFeatureToggle.setAllEnabled(this.callingThreadFeatureToggles);
                T t = this.delegate.call();
                return t;
            }
            finally {
                EFeatureToggle.setAllEnabled(inheritedFeatureToggles);
            }
        }
    }

    private static class FeatureTogglePropagatingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final EnumSet<EFeatureToggle> callingThreadFeatureToggles;

        public FeatureTogglePropagatingRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.callingThreadFeatureToggles = EFeatureToggle.getAllEnabled();
        }

        @Override
        public void run() {
            EnumSet<EFeatureToggle> inheritedFeatureToggles = EFeatureToggle.getAllEnabled();
            try {
                EFeatureToggle.setAllEnabled(this.callingThreadFeatureToggles);
                this.delegate.run();
            }
            finally {
                EFeatureToggle.setAllEnabled(inheritedFeatureToggles);
            }
        }
    }
}

