/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.retry;

import com.teamscale.core.rest.client.retry.HttpRequestRetryInterceptor;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import okhttp3.Interceptor;
import org.jetbrains.annotations.VisibleForTesting;

public class HttpRequestRetryPolicy {
    private static final String RETRY_ATTEMPTS_PROPERTY_NAME = "com.teamscale.client.request-retry.attempts";
    private static final String RETRY_DELAY_PROPERTY_NAME = "com.teamscale.client.request-retry.delay-millis";
    public static final Function<IOException, Boolean> RETRY_ALL_MESSAGES_FILTER = e -> true;
    private static final Function<IOException, Boolean> CONTAINS_CONNECTION_RESET_FILTER = e -> e.getMessage().contains("Connection reset");
    public static final Map<Class<? extends IOException>, Function<IOException, Boolean>> DEFAULT_RETRY_EXCEPTION_TYPES_AND_MESSAGE_FILTERS = Map.of(SocketTimeoutException.class, RETRY_ALL_MESSAGES_FILTER, SocketException.class, CONTAINS_CONNECTION_RESET_FILTER);
    public static final HttpRequestRetryPolicy SYSTEM_DEFAULT = new HttpRequestRetryPolicy(Integer.getInteger("com.teamscale.client.request-retry.attempts", 3), Duration.ofMillis(Integer.getInteger("com.teamscale.client.request-retry.delay-millis", 1000).intValue()), DEFAULT_RETRY_EXCEPTION_TYPES_AND_MESSAGE_FILTERS);
    public static final HttpRequestRetryPolicy AZURE_DEVOPS = new HttpRequestRetryPolicy(HttpRequestRetryPolicy.getNumberOfRetriesForAzureDevOps(), HttpRequestRetryPolicy.getRetryDelayForAzureDevOps(), DEFAULT_RETRY_EXCEPTION_TYPES_AND_MESSAGE_FILTERS);
    private final int numberOfRetries;
    public final Duration initialDelay;
    private final Map<Class<? extends IOException>, Function<IOException, Boolean>> retryExceptionTypesAndMessageFilters;

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public boolean isExceptionToRetry(IOException e) {
        return this.retryExceptionTypesAndMessageFilters.containsKey(e.getClass()) && this.retryExceptionTypesAndMessageFilters.get(e.getClass()).apply(e) != false;
    }

    public Map<Class<? extends IOException>, Function<IOException, Boolean>> getRetryExceptionTypesAndMessageFilters() {
        return this.retryExceptionTypesAndMessageFilters;
    }

    public HttpRequestRetryPolicy(int numberOfRetries, Duration initialDelay) {
        this(numberOfRetries, initialDelay, HttpRequestRetryPolicy.SYSTEM_DEFAULT.retryExceptionTypesAndMessageFilters);
    }

    public HttpRequestRetryPolicy(int numberOfRetries, Duration initialDelay, Map<Class<? extends IOException>, Function<IOException, Boolean>> retryExceptionTypesAndMessageFilters) {
        this.numberOfRetries = numberOfRetries;
        this.initialDelay = initialDelay;
        this.retryExceptionTypesAndMessageFilters = retryExceptionTypesAndMessageFilters;
    }

    public HttpRequestRetryPolicy(Map<Class<? extends IOException>, Function<IOException, Boolean>> retryExceptionTypesAndMessageFilters) {
        this.numberOfRetries = HttpRequestRetryPolicy.SYSTEM_DEFAULT.numberOfRetries;
        this.initialDelay = HttpRequestRetryPolicy.SYSTEM_DEFAULT.initialDelay;
        this.retryExceptionTypesAndMessageFilters = retryExceptionTypesAndMessageFilters;
    }

    public Interceptor createInterceptor() {
        return new HttpRequestRetryInterceptor(this);
    }

    @VisibleForTesting
    Interceptor createInterceptor(HttpRequestRetryInterceptor.ISleeper sleeper) {
        return new HttpRequestRetryInterceptor(this, sleeper);
    }

    private static int getNumberOfRetriesForAzureDevOps() {
        Integer retries = Integer.getInteger("azure-devops.timeout-retry.attempts");
        if (retries != null) {
            return retries;
        }
        return Integer.getInteger(RETRY_ATTEMPTS_PROPERTY_NAME, 5);
    }

    private static Duration getRetryDelayForAzureDevOps() {
        Integer delay = Integer.getInteger("azure-devops.timeout-retry.delay-millis");
        if (delay != null) {
            return Duration.ofMillis(delay.intValue());
        }
        return Duration.ofMillis(Integer.getInteger(RETRY_DELAY_PROPERTY_NAME, 1000).intValue());
    }
}

