/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.datahandler.AnnotationLayoutData;
import org.conqat.lib.simulink.model.datahandler.FontData;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.LayoutHandlerBase;
import org.jspecify.annotations.Nullable;

public class SimulinkAnnotationUIData {
    @JsonProperty(value="annotationLayoutData")
    private final AnnotationLayoutData annotationLayoutData;
    @JsonProperty(value="text")
    private @Nullable String text;
    @JsonProperty(value="font")
    private FontData fontData;
    @JsonProperty(value="qualifiedName")
    private final String qualifiedName;

    public SimulinkAnnotationUIData(SimulinkAnnotation annotation) {
        this.qualifiedName = annotation.buildQualifiedName();
        this.annotationLayoutData = annotation.obtainLayoutData();
        LabelLayoutData labelLayoutData = annotation.obtainLabelData();
        if (labelLayoutData != null) {
            this.text = annotation.obtainLabelData().getText();
        }
        this.fontData = LayoutHandlerBase.extractFontData(annotation);
    }

    public AnnotationLayoutData getAnnotationLayoutData() {
        return this.annotationLayoutData;
    }

    public String getText() {
        return this.text;
    }
}

