/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import com.teamscale.commons.TeamscaleInstallationUtils;
import eu.cqse.check.framework.core.registry.Guideline;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.Nullable;

public class GuidelineMapping {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String GUIDELINE_METADATA_FILE = "guideline.txt";
    private static final String GUIDELINE_RULES_TSV = "guideline-rules.tsv";
    private static final String GUIDELINE_RULES_TO_CHECKS_TSV = "guideline-rules-to-checks.tsv";
    private static GuidelineMapping instance = null;
    private final List<Guideline> guidelines = new ArrayList<Guideline>();
    private final TwoDimHashMap<String, String, RulesetInfo> rulesByRuleIdAndGuideline = new TwoDimHashMap();
    private final TwoDimHashMap<String, String, RulesetInfo> rulesByGuidelineAndDescription = new TwoDimHashMap();
    private final Map<ELanguage, ListMap<String, RulesetInfo>> rulesByCheckIdByLanguage = new HashMap<ELanguage, ListMap<String, RulesetInfo>>();
    private final ListMap<String, RulesetInfo> rulesByCheckId = new ListMap();
    private static final String CUSTOM_GUIDELINE_FOLDER = "guidelines";
    private final @Nullable File guidelineDirectory;

    private GuidelineMapping(Class<?> clazz, @Nullable File guidelineDirectory) {
        this.guidelineDirectory = guidelineDirectory;
        ListMap<String, GuidelineInfo> customGuidelines = this.loadCustomGuidelines();
        ListMap<String, GuidelineInfo> guidelineResources = GuidelineMapping.getResourceByGuideline(clazz);
        this.readGuidelines(guidelineResources);
        this.readGuidelines(customGuidelines);
    }

    private void readGuidelines(ListMap<String, GuidelineInfo> guidelineResources) {
        try {
            for (String guidelineId : guidelineResources.getKeys()) {
                GuidelineInfo guidelineInfo = (GuidelineInfo)((List)guidelineResources.getCollectionOrEmpty((Object)guidelineId)).getFirst();
                List<String> guidelineMetadata = guidelineInfo.guidelineTxt;
                Guideline guideline = GuidelineMapping.readGuidelineMetadataFromTSV(guidelineMetadata);
                this.guidelines.add(guideline);
                List<String> guidelineRule = guidelineInfo.guidelineRuleTxt;
                List<String> guidelineToChecks = guidelineInfo.rulesToChecksTsv;
                GuidelineMapping.readRulesFromTSV(guidelineRule, guideline.readableName(), this.rulesByRuleIdAndGuideline, this.rulesByGuidelineAndDescription);
                ListMap<String, RulesetInfo> newRulesByCheckId = this.readCheckRulesMappingFromTSV(guidelineToChecks);
                this.rulesByCheckId.addAll(newRulesByCheckId);
                for (ELanguage language : guideline.supportedLanguages()) {
                    this.addRules(language, (ListMap<String, RulesetInfo>)new ListMap(newRulesByCheckId));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error loading guideline mappings", (Throwable)e);
        }
    }

    private static void removeHeader(List<String> lines, String headerSubstring) {
        if (lines.getFirst().contains(headerSubstring)) {
            lines.removeFirst();
        }
    }

    private ListMap<String, GuidelineInfo> loadCustomGuidelines() {
        if (this.guidelineDirectory == null) {
            return new ListMap();
        }
        if (!this.guidelineDirectory.isDirectory()) {
            LOGGER.error("Guideline directory is not a directory: {}", (Object)this.guidelineDirectory);
            return new ListMap();
        }
        ListMap byGuideline = new ListMap();
        File[] guidelines = this.guidelineDirectory.listFiles(File::isDirectory);
        if (guidelines == null) {
            return byGuideline;
        }
        for (File guidelineFolder : guidelines) {
            try {
                List<String> guidelineTxt = GuidelineMapping.getSpecificFilesAsResources(guidelineFolder, GUIDELINE_METADATA_FILE);
                List<String> guidelineRules = GuidelineMapping.getSpecificFilesAsResources(guidelineFolder, GUIDELINE_RULES_TSV);
                List<String> guidelineRulesToChecksTsv = GuidelineMapping.getSpecificFilesAsResources(guidelineFolder, GUIDELINE_RULES_TO_CHECKS_TSV);
                GuidelineMapping.removeHeader(guidelineRules, "ID in Guidelines");
                GuidelineMapping.removeHeader(guidelineRulesToChecksTsv, "Guideline Rule ID");
                GuidelineInfo guidelineInfo = new GuidelineInfo(this.guidelineDirectory.getName(), guidelineTxt, guidelineRules, guidelineRulesToChecksTsv);
                byGuideline.add((Object)guidelineFolder.getName(), (Object)guidelineInfo);
            }
            catch (IOException e) {
                LOGGER.error("Error loading custom guideline from directory {}", (Object)guidelineFolder.getAbsolutePath(), (Object)e);
            }
        }
        return byGuideline;
    }

    private static List<String> getSpecificFilesAsResources(File directory, String filename) throws IOException {
        Path path = Path.of(directory.getAbsolutePath(), filename);
        List lines = FileSystemUtils.readLinesUTF8((Path)path);
        return lines;
    }

    private static ListMap<String, GuidelineInfo> getResourceByGuideline(Class<?> clazz) {
        List resources = ResourceUtils.listResourcesRecursively(clazz, (String)"/META-INF/guidelines/");
        ListMap resourcesByGuideline = new ListMap();
        for (Resource res : resources) {
            String id = Paths.get(res.getPath(), new String[0]).getName(2).toString();
            resourcesByGuideline.add((Object)id, (Object)res);
        }
        ListMap guidelineInfos = new ListMap();
        for (String guidelineId : resourcesByGuideline.getKeys()) {
            List res = (List)resourcesByGuideline.getCollectionOrEmpty((Object)guidelineId);
            Map<String, List<Resource>> guidelineFilesByName = res.stream().collect(Collectors.groupingBy(Resource::getName));
            List<String> guidelineMetadata = GuidelineMapping.getLinesFromResource(guidelineFilesByName.get(GUIDELINE_METADATA_FILE).getFirst(), false);
            List<String> guidelineRules = GuidelineMapping.getLinesFromResource(guidelineFilesByName.get(GUIDELINE_RULES_TSV).getFirst(), true);
            List<String> guidelineRulesToChecksTsv = GuidelineMapping.getLinesFromResource(guidelineFilesByName.get(GUIDELINE_RULES_TO_CHECKS_TSV).getFirst(), true);
            GuidelineInfo guidelineInfo = new GuidelineInfo(guidelineId, guidelineMetadata, guidelineRules, guidelineRulesToChecksTsv);
            guidelineInfos.add((Object)guidelineId, (Object)guidelineInfo);
        }
        return guidelineInfos;
    }

    private void addRules(ELanguage language, ListMap<String, RulesetInfo> newEntries) {
        if (this.rulesByCheckIdByLanguage.containsKey(language)) {
            ListMap<String, RulesetInfo> existingEntries = this.rulesByCheckIdByLanguage.get(language);
            existingEntries.addAll(newEntries);
            this.rulesByCheckIdByLanguage.put(language, existingEntries);
        } else {
            this.rulesByCheckIdByLanguage.put(language, newEntries);
        }
    }

    @TestOnly
    public static void createTestInstance(Class<?> clazz, File configDirectory) {
        instance = new GuidelineMapping(clazz, configDirectory);
    }

    public static GuidelineMapping getInstance() {
        if (instance == null) {
            File guidelineDirectory = TeamscaleInstallationUtils.locateConfigFile((String)CUSTOM_GUIDELINE_FOLDER).orElse(null);
            instance = new GuidelineMapping(GuidelineMapping.class, guidelineDirectory);
        }
        return instance;
    }

    public ListMap<String, RulesetInfo> getRulesByCheckId() {
        return this.rulesByCheckId;
    }

    public ListMap<String, RulesetInfo> getRulesByCheckId(Set<ELanguage> languages) {
        ListMap result = new ListMap();
        for (ELanguage language : languages) {
            ListMap<String, RulesetInfo> entries = this.rulesByCheckIdByLanguage.get(language);
            if (entries == null) continue;
            result.addAll(entries);
        }
        return result;
    }

    public SetMap<String, String> getRulesByGuidelineName(String checkId, Set<ELanguage> languages) {
        SetMap rulesByGuidelineId = new SetMap();
        List rules = (List)this.getRulesByCheckId(languages).getCollectionOrEmpty((Object)checkId);
        for (RulesetInfo rule : rules) {
            rulesByGuidelineId.add((Object)rule.rulesetName, (Object)rule.getFullDescription());
        }
        return rulesByGuidelineId;
    }

    public List<Guideline> getGuidelines() {
        return this.guidelines;
    }

    private static Guideline readGuidelineMetadataFromTSV(List<String> lines) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (String line : lines) {
            Pair keyAndValue = StringUtils.splitAtFirst((String)line, (char)':');
            metadata.put(((String)keyAndValue.getFirst()).trim(), ((String)keyAndValue.getSecond()).trim());
        }
        String readableName = (String)metadata.get("Readable Name");
        List languagesAsText = StringUtils.splitToList((String)((String)metadata.get("Language")), (String)",");
        String author = (String)metadata.get("Author/Organization");
        String releaseDate = (String)metadata.get("Release Date");
        String description = (String)metadata.get("Description");
        String infoUrl = (String)metadata.get("Further Info URL");
        EnumSet languages = EnumUtils.valuesOf(ELanguage.class, (Collection)languagesAsText);
        return new Guideline(readableName, languages, author, releaseDate, description, infoUrl);
    }

    private static void readRulesFromTSV(List<String> guidelineRules, String guidelineName, TwoDimHashMap<String, String, RulesetInfo> rulesByRuleIdAndGuideline, TwoDimHashMap<String, String, RulesetInfo> rulesByGuidelineAndDescription) throws IOException {
        for (String line : guidelineRules) {
            String[] splittedLine = line.split("\t");
            String ruleId = splittedLine[0];
            String ruleName = splittedLine[1];
            String ruleCategory = null;
            if (splittedLine.length >= 3) {
                ruleCategory = splittedLine[2];
            }
            RulesetInfo rule = new RulesetInfo(ruleId, ruleName, guidelineName, ruleCategory);
            rulesByRuleIdAndGuideline.putValue((Object)rule.ruleId, (Object)rule.rulesetName, (Object)rule);
            rulesByGuidelineAndDescription.putValue((Object)rule.rulesetName, (Object)rule.getFullDescription(), (Object)rule);
        }
    }

    private ListMap<String, RulesetInfo> readCheckRulesMappingFromTSV(List<String> checkRulesMappings) throws IOException {
        ListMap rulesByCheckId = new ListMap();
        for (String line : checkRulesMappings) {
            if (line.isBlank()) continue;
            String[] splittedLine = line.split("\t");
            String ruleId = splittedLine[1].trim();
            String checkId = splittedLine[0].trim();
            Collection rules = this.rulesByRuleIdAndGuideline.getValuesByFirstKey((Object)ruleId);
            if (rules == null) continue;
            rulesByCheckId.addAll((Object)checkId, rules);
        }
        return rulesByCheckId;
    }

    private static List<String> getLinesFromResource(Resource resource, boolean removeHeader) {
        List lines = resource.getLines();
        lines.removeIf(String::isEmpty);
        if (removeHeader) {
            lines.removeFirst();
        }
        return lines;
    }

    public Collection<RulesetInfo> getRuleNames(String guideline) {
        return this.rulesByGuidelineAndDescription.getValuesByFirstKey((Object)guideline);
    }

    public Optional<RulesetInfo> getRule(String guidelineName, String ruleDescription) {
        return Optional.ofNullable((RulesetInfo)this.rulesByGuidelineAndDescription.getValue((Object)guidelineName, (Object)ruleDescription));
    }

    private record GuidelineInfo(String name, List<String> guidelineTxt, List<String> guidelineRuleTxt, List<String> rulesToChecksTsv) {
    }
}

