/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.javascript;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptShallowParser;
import java.util.List;

public class YuiCallRecognizer
extends RecognizerBase<JavaScriptShallowParser.EJavaScriptParserStates> {
    private static final String YUI = "YUI";
    private final String methodName;

    public YuiCallRecognizer(String methodName) {
        this.methodName = methodName;
    }

    @Override
    protected int matchesLocally(ParserState<JavaScriptShallowParser.EJavaScriptParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (tokens.size() - startOffset < 3) {
            return -1;
        }
        if (YuiCallRecognizer.isNoIdentifier(tokens.get(startOffset), YUI)) {
            return -1;
        }
        if (tokens.get(startOffset + 1).getType() == ETokenType.LPAREN) {
            if (tokens.get(startOffset + 2).getType() != ETokenType.RPAREN || tokens.size() - startOffset < 5) {
                return -1;
            }
            startOffset += 2;
        }
        if (tokens.get(startOffset + 1).getType() != ETokenType.DOT) {
            return -1;
        }
        if (YuiCallRecognizer.isNoIdentifier(tokens.get(startOffset + 2), this.methodName)) {
            return -1;
        }
        return startOffset + 3;
    }

    private static boolean isNoIdentifier(IToken token, String name) {
        return ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{name})}).negated().matches(token);
    }
}

