/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.rust;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.rust.RustShallowParser;
import java.util.List;

public class RustSubExpressionRecognizer
extends RecognizerBase<RustShallowParser.ERustParserStates> {
    private static final ITokenMatcher SUB_STRUCTURE_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.MATCH});
    private static final ITokenMatcher SUB_BLOCK_INDICATOR_CLASSES = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.DELIMITER});
    private static final ITokenMatcher SUB_BLOCK_EXCLUDED_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.GT});
    private static final ITokenMatcher LAMBDA_INDICATOR_CLASSES = ITokenMatcher.anyOfClass((ETokenType.ETokenClass[])new ETokenType.ETokenClass[]{ETokenType.ETokenClass.OPERATOR, ETokenType.ETokenClass.DELIMITER});
    private static final ITokenMatcher LAMBDA_EXCLUDED_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE});
    private static final ITokenMatcher LAMBDA_START_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OR, ETokenType.OROR});

    @Override
    protected int matchesLocally(ParserState<RustShallowParser.ERustParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset < tokens.size()) {
            if (RustSubExpressionRecognizer.isSubStructureStart(tokens, startOffset)) {
                return parserState.parse(RustShallowParser.ERustParserStates.IN_EXPRESSION, tokens, startOffset);
            }
            if (RustSubExpressionRecognizer.isSubBlockStart(tokens, startOffset)) {
                return parserState.parse(RustShallowParser.ERustParserStates.IN_EXPRESSION, tokens, startOffset + 1);
            }
            if (RustSubExpressionRecognizer.isLambdaStart(tokens, startOffset)) {
                return parserState.parse(RustShallowParser.ERustParserStates.IN_EXPRESSION, tokens, startOffset);
            }
        }
        return -1;
    }

    private static boolean isSubStructureStart(List<IToken> tokens, int startOffset) {
        return SUB_STRUCTURE_START_TOKENS.matches(tokens.get(startOffset));
    }

    private static boolean isSubBlockStart(List<IToken> tokens, int startOffset) {
        IToken firstToken = tokens.get(startOffset);
        return !SUB_BLOCK_EXCLUDED_TOKENS.matches(firstToken) && SUB_BLOCK_INDICATOR_CLASSES.matches(firstToken) && TokenStreamUtils.hasTokenTypeSequence(tokens, startOffset + 1, ETokenType.LBRACE);
    }

    private static boolean isLambdaStart(List<IToken> tokens, int startOffset) {
        if (!RustSubExpressionRecognizer.isLambdaIndicated(tokens, startOffset)) {
            return false;
        }
        return startOffset >= 0 && LAMBDA_START_TOKENS.matches(tokens.get(startOffset));
    }

    private static boolean isLambdaIndicated(List<IToken> tokens, int startOffset) {
        if (startOffset <= 0) {
            return false;
        }
        IToken previousToken = tokens.get(startOffset - 1);
        return LAMBDA_INDICATOR_CLASSES.matches(previousToken) && !LAMBDA_EXCLUDED_TOKENS.matches(previousToken);
    }
}

