/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire.data;

import java.text.ParseException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonarsource.kotlin.surefire.data.UnitTestClassReport;
import org.sonarsource.kotlin.surefire.data.UnitTestIndex;
import org.sonarsource.kotlin.surefire.data.UnitTestResult;

public class SurefireStaxHandler {
    private final UnitTestIndex index;

    public SurefireStaxHandler(UnitTestIndex index2) {
        this.index = index2;
    }

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuite = rootCursor.constructDescendantCursor(new ElementFilter("testsuite"));
        SMEvent testSuiteEvent = testSuite.getNext();
        while (testSuiteEvent != null) {
            if (testSuiteEvent.compareTo(SMEvent.START_ELEMENT) == 0) {
                String testSuiteClassName = testSuite.getAttrValue("name");
                this.parseTestCase(testSuiteClassName, testSuite.childCursor(new ElementFilter("testcase")));
            }
            testSuiteEvent = testSuite.getNext();
        }
    }

    private void parseTestCase(String testSuiteClassName, SMInputCursor testCase) throws XMLStreamException {
        SMEvent event = testCase.getNext();
        while (event != null) {
            if (event.compareTo(SMEvent.START_ELEMENT) == 0) {
                String testClassName = SurefireStaxHandler.getClassname(testCase, testSuiteClassName);
                UnitTestClassReport classReport = this.index.index(testClassName);
                SurefireStaxHandler.parseTestCase(testCase, testSuiteClassName, classReport);
            }
            event = testCase.getNext();
        }
    }

    private static String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        int openParenthesisIndex;
        String testClassName = testCaseCursor.getAttrValue("classname");
        if (testClassName != null && !testClassName.matches("\\s*") && testClassName.endsWith(")") && (openParenthesisIndex = testClassName.indexOf(40)) > 0) {
            testClassName = testClassName.substring(0, openParenthesisIndex);
        }
        return testClassName == null || testClassName.matches("\\s*") ? defaultClassname : testClassName;
    }

    private static void parseTestCase(SMInputCursor testCaseCursor, String testSuiteClassName, UnitTestClassReport report2) throws XMLStreamException {
        report2.add(SurefireStaxHandler.parseTestResult(testCaseCursor, testSuiteClassName));
    }

    private static UnitTestResult parseTestResult(SMInputCursor testCaseCursor, String testSuiteClassName) throws XMLStreamException {
        UnitTestResult detail = new UnitTestResult();
        String name = SurefireStaxHandler.getTestCaseName(testCaseCursor);
        detail.setName(name);
        detail.setTestSuiteClassName(testSuiteClassName);
        String status2 = "ok";
        String time = testCaseCursor.getAttrValue("time");
        Long duration = null;
        SMInputCursor childNode = testCaseCursor.descendantElementCursor();
        if (childNode.getNext() != null) {
            String elementName = childNode.getLocalName();
            if ("skipped".equals(elementName)) {
                status2 = "skipped";
                duration = 0L;
            } else if ("failure".equals(elementName)) {
                status2 = "failure";
            } else if ("error".equals(elementName)) {
                status2 = "error";
            }
        }
        while (childNode.getNext() != null) {
        }
        if (duration == null) {
            duration = SurefireStaxHandler.getTimeAttributeInMS(time);
        }
        detail.setDurationMilliseconds(duration);
        detail.setStatus(status2);
        return detail;
    }

    private static long getTimeAttributeInMS(String value2) throws XMLStreamException {
        try {
            Double time = ParsingUtils.parseNumber((String)value2, (Locale)Locale.ENGLISH);
            return !Double.isNaN(time) ? (long)ParsingUtils.scaleValue((double)(time * 1000.0), (int)3) : 0L;
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
    }

    private static String getTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String classname = testCaseCursor.getAttrValue("classname");
        String name = testCaseCursor.getAttrValue("name");
        if (classname != null && classname.contains("$")) {
            return classname.substring(classname.indexOf(36) + 1) + "/" + name;
        }
        return name;
    }
}

