/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;

public class ExpressionTreeBuilder {
    private static final ITokenMatcher CONNECTING_LOGICAL_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.OROR, ETokenType.ANDAND});

    public static ExpressionTreeNode buildExpressionTree(List<IToken> expression, IOperatorInformation operatorInformation, boolean expandFunctionCalls, boolean couldContainGeneric, boolean removeParentheses) {
        ExpressionTreeNode node = new ExpressionTreeNode(operatorInformation, null, new ArrayList<ExpressionTreeNode>(), new ArrayList<IToken>(expression), expandFunctionCalls, couldContainGeneric, removeParentheses);
        node.expandTree();
        return node;
    }

    private static boolean isPartOfGeneric(List<IToken> expression, int index) {
        if (expression.get(index).getType() == ETokenType.LT) {
            int end = TokenStreamUtils.findMatchingClosingToken(expression, (int)(index + 1), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT);
            return end != -1 && TokenStreamUtils.firstTokenMatching(expression, (int)index, (int)end, (ITokenMatcher)CONNECTING_LOGICAL_OPERATORS) == -1;
        }
        if (expression.get(index).getType() == ETokenType.GT) {
            int start = TokenStreamUtils.findMatchingOpeningToken(expression, (int)(index - 1), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT);
            return start != -1 && TokenStreamUtils.firstTokenMatching(expression, (int)start, (int)index, (ITokenMatcher)CONNECTING_LOGICAL_OPERATORS) == -1;
        }
        return false;
    }

    public static Set<Integer> getGenericTokens(boolean couldContainGeneric, int startToken, int endToken, List<IToken> expression, IOperatorInformation operatorInformation) {
        if (!couldContainGeneric) {
            return Set.of();
        }
        List operatorIndices = TokenStreamUtils.getTopLevelTokenTypeIndices(expression, (int)startToken, (int)endToken, Set.of(ETokenType.LT), operatorInformation.openingTypes(), operatorInformation.closingTypes());
        HashSet<Integer> genericTokenIndices = new HashSet<Integer>();
        Iterator iterator = operatorIndices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!ExpressionTreeBuilder.isPartOfGeneric(expression, index)) continue;
            for (int i = index; i <= TokenStreamUtils.findMatchingClosingToken(expression, (int)(index + 1), (ETokenType)ETokenType.LT, (ETokenType)ETokenType.GT); ++i) {
                genericTokenIndices.add(i);
            }
        }
        return genericTokenIndices;
    }

    public static List<IToken> removeSurroundingParentheses(List<IToken> expression, IOperatorInformation operatorInformation) {
        List<Object> subExpression = new ArrayList<IToken>(expression);
        while (!subExpression.isEmpty() && operatorInformation.openingTypes().contains(((IToken)subExpression.get(0)).getType()) && TokenStreamUtils.findMatchingClosingToken(subExpression, (int)1, operatorInformation.openingTypes(), operatorInformation.closingTypes()) == subExpression.size() - 1) {
            subExpression = subExpression.subList(1, subExpression.size() - 1);
        }
        return subExpression;
    }

    public static List<IToken> removeEOLTokens(List<IToken> expression) {
        while (expression != null && expression.size() > 0 && (expression.get(expression.size() - 1).getType() == ETokenType.EOL || expression.get(expression.size() - 1).getType() == ETokenType.COLON || expression.get(expression.size() - 1).getType() == ETokenType.SEMICOLON)) {
            expression.remove(expression.size() - 1);
        }
        return expression;
    }

    static List<ExpressionTreeNode> splitExpressionOn(Set<ETokenType> operators, Set<Integer> genericExpressionBoundaries, ExpressionTreeNode node) {
        ArrayList<ExpressionTreeNode> operands = new ArrayList<ExpressionTreeNode>();
        List<Integer> operatorIndices = TokenStreamUtils.getTopLevelTokenTypeIndices(node.expression, new HashSet<ETokenType>(operators), node.operatorInformation.openingTypes(), node.operatorInformation.closingTypes());
        if ((operatorIndices = operatorIndices.stream().filter(i -> !genericExpressionBoundaries.contains(i)).toList()).isEmpty()) {
            return operands;
        }
        Set unaryOperatorIndices = operatorIndices.stream().filter(i -> node.operatorInformation.unaryOperators().contains(node.expression.get((int)i).getType()) && (i == 0 || node.operatorInformation.allOpeningTypes().contains(node.expression.get(i - 1).getType()) || node.expression.get(i - 1).getType().isOperator() || node.expression.get(i - 1).getType() == ETokenType.COMMA || node.operatorInformation.unaryOperators().contains(node.expression.get(i - 1).getType()) || i == node.expression.size() - 1 || node.expression.get(i + 1).getType() == ETokenType.COMMA || node.operatorInformation.allClosingTypes().contains(node.expression.get(i + 1).getType()))).collect(Collectors.toUnmodifiableSet());
        int operatorIndex = operatorIndices.get(operatorIndices.size() - 1);
        if (operatorIndices.size() > unaryOperatorIndices.size()) {
            for (int i2 = operatorIndices.size() - 1; i2 >= 0 && unaryOperatorIndices.contains(operatorIndex); --i2) {
                operatorIndex = operatorIndices.get(i2);
            }
        } else {
            operatorIndex = operatorIndices.get(0);
        }
        return node.splitExpressionOn(operands, operatorIndex, operatorIndices, operators.size() == 1);
    }
}

