/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.formatting;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.api.PHPPunctuator;
import org.sonar.php.checks.FormattingStandardCheck;
import org.sonar.php.checks.formatting.FormattingCheck;
import org.sonar.php.checks.formatting.TokenUtils;
import org.sonar.php.checks.utils.TokenVisitor;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterListTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class CurlyBraceCheck
extends PHPVisitorCheck
implements FormattingCheck {
    private static final String DECLARATIONS_OPEN_CURLY_MESSAGE = "Move this open curly brace to the beginning of the next line.";
    private static final String CONTROL_STRUCTURES_OPEN_CURLY_MESSAGE = "Move this open curly brace to the end of the previous line.";
    private static final String KEYWORD_MESSAGE = "Move this \"%s\" to the same line as the previous closing curly brace.";
    private FormattingStandardCheck check = null;

    @Override
    public void checkFormat(FormattingStandardCheck formattingCheck, ScriptTree scriptTree) {
        this.check = formattingCheck;
        super.visitScript(scriptTree);
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        SyntaxToken previousToken = new TokenVisitor(tree).prevToken(tree.openCurlyBraceToken());
        this.checkDeclarationOpenCurly(previousToken, tree.openCurlyBraceToken());
        super.visitClassDeclaration(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (tree.body().is(Tree.Kind.BLOCK)) {
            this.checkDeclarationOpenCurly(CurlyBraceCheck.getPreviousToken(tree.parameters()), ((BlockTree)tree.body()).openCurlyBraceToken());
        }
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.checkDeclarationOpenCurly(CurlyBraceCheck.getPreviousToken(tree.parameters()), tree.body().openCurlyBraceToken());
        super.visitFunctionDeclaration(tree);
    }

    private static SyntaxToken getPreviousToken(ParameterListTree parameterList) {
        return new TokenVisitor(parameterList).prevToken(parameterList.closeParenthesisToken());
    }

    @Override
    public void visitElseifClause(ElseifClauseTree tree) {
        this.checkControlStructureOpenCurly(tree.condition().closeParenthesis(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        super.visitElseifClause(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.condition().closeParenthesis(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        ElseClauseTree elseClause = tree.elseClause();
        if (elseClause != null) {
            this.checkCloseCurlyNextToKeyword(new TokenVisitor(tree).prevToken(elseClause.elseToken()), elseClause.elseToken());
        }
        tree.elseifClauses().stream().map(ElseifClauseTree::elseifToken).forEach(elseIfClause -> this.checkCloseCurlyNextToKeyword(new TokenVisitor(tree).prevToken((SyntaxToken)elseIfClause), (SyntaxToken)elseIfClause));
        super.visitIfStatement(tree);
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        this.checkControlStructureOpenCurly(tree.elseToken(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        super.visitElseClause(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.condition().closeParenthesis(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        if (tree.statement().is(Tree.Kind.BLOCK)) {
            this.checkControlStructureOpenCurly(tree.doToken(), ((BlockTree)tree.statement()).openCurlyBraceToken());
        }
        super.visitDoWhileStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.closeParenthesisToken(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        super.visitForStatement(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.closeParenthesisToken(), CurlyBraceCheck.getOpenCurlyIfBlock(tree.statements()));
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.checkControlStructureOpenCurly(tree.closeParenthesisToken(), tree.block().openCurlyBraceToken());
        super.visitCatchBlock(tree);
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.tryToken(), tree.block().openCurlyBraceToken());
        TokenVisitor tokenVisitor = new TokenVisitor(tree);
        for (CatchBlockTree catchBlock : tree.catchBlocks()) {
            this.checkCloseCurlyNextToKeyword(tokenVisitor.prevToken(catchBlock.catchToken()), catchBlock.catchToken());
        }
        if (tree.finallyBlock() != null) {
            this.checkCloseCurlyNextToKeyword(tokenVisitor.prevToken(tree.finallyToken()), tree.finallyToken());
        }
        super.visitTryStatement(tree);
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.checkControlStructureOpenCurly(tree.expression().closeParenthesis(), tree.openCurlyBraceToken());
        super.visitSwitchStatement(tree);
    }

    private void checkDeclarationOpenCurly(@Nullable SyntaxToken previousToken, @Nullable SyntaxToken openCurly) {
        if (!this.check.isOpenCurlyBraceForClassAndFunction || previousToken == null || openCurly == null) {
            return;
        }
        if (TokenUtils.isOnSameLine(previousToken, openCurly)) {
            this.reportIssue(openCurly, DECLARATIONS_OPEN_CURLY_MESSAGE);
        }
    }

    private void checkControlStructureOpenCurly(@Nullable SyntaxToken previousToken, @Nullable SyntaxToken openCurly) {
        if (!this.check.isOpenCurlyBraceForControlStructures || previousToken == null || openCurly == null) {
            return;
        }
        if (!TokenUtils.isOnSameLine(previousToken, openCurly)) {
            this.reportIssue(openCurly, CONTROL_STRUCTURES_OPEN_CURLY_MESSAGE);
        }
    }

    private void checkCloseCurlyNextToKeyword(@Nullable SyntaxToken previousToken, @Nullable SyntaxToken keyword) {
        if (!this.check.isClosingCurlyNextToKeyword || previousToken == null || keyword == null) {
            return;
        }
        if (CurlyBraceCheck.isCloseCurly(previousToken) && !TokenUtils.isOnSameLine(previousToken, keyword)) {
            this.reportIssue(keyword, String.format(KEYWORD_MESSAGE, keyword.text()));
        }
    }

    private static boolean isCloseCurly(SyntaxToken token) {
        return PHPPunctuator.RCURLYBRACE.getValue().equals(token.text());
    }

    @Nullable
    private static SyntaxToken getOpenCurlyIfBlock(List<StatementTree> statements) {
        if (!statements.isEmpty()) {
            StatementTree firstStmt = statements.get(0);
            return firstStmt.is(Tree.Kind.BLOCK) ? ((BlockTree)firstStmt).openCurlyBraceToken() : null;
        }
        return null;
    }

    private void reportIssue(Tree tree, String message) {
        this.check.reportIssue(message, tree);
    }
}

