/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.lang;

import java.util.Objects;
import org.conqat.lib.commons.error.ExceptionUtils;
import org.conqat.lib.commons.function.RunnableWithException;

public interface SilentAutoClosable
extends AutoCloseable {
    @Override
    public void close();

    default public SilentAutoClosable andThen(SilentAutoClosable after) {
        Objects.requireNonNull(after, "after");
        return () -> {
            RunnableWithException[] runnableWithExceptionArray = new RunnableWithException[2];
            runnableWithExceptionArray[0] = this::close;
            runnableWithExceptionArray[1] = after::close;
            ExceptionUtils.runAllAndAddAsSuppressed(RuntimeException.class, runnableWithExceptionArray);
        };
    }

    public static SilentAutoClosable empty() {
        return () -> {};
    }
}

