/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.build.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.build.webapi.Build;
import com.microsoft.alm.teamfoundation.build.webapi.BuildArtifact;
import com.microsoft.alm.teamfoundation.build.webapi.BuildBadge;
import com.microsoft.alm.teamfoundation.build.webapi.BuildController;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinition;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinitionReference;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinitionRevision;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinitionTemplate;
import com.microsoft.alm.teamfoundation.build.webapi.BuildLog;
import com.microsoft.alm.teamfoundation.build.webapi.BuildMetric;
import com.microsoft.alm.teamfoundation.build.webapi.BuildOptionDefinition;
import com.microsoft.alm.teamfoundation.build.webapi.BuildQueryOrder;
import com.microsoft.alm.teamfoundation.build.webapi.BuildReason;
import com.microsoft.alm.teamfoundation.build.webapi.BuildReportMetadata;
import com.microsoft.alm.teamfoundation.build.webapi.BuildResourceUsage;
import com.microsoft.alm.teamfoundation.build.webapi.BuildResult;
import com.microsoft.alm.teamfoundation.build.webapi.BuildSettings;
import com.microsoft.alm.teamfoundation.build.webapi.BuildStatus;
import com.microsoft.alm.teamfoundation.build.webapi.Change;
import com.microsoft.alm.teamfoundation.build.webapi.DefinitionQueryOrder;
import com.microsoft.alm.teamfoundation.build.webapi.Folder;
import com.microsoft.alm.teamfoundation.build.webapi.FolderQueryOrder;
import com.microsoft.alm.teamfoundation.build.webapi.QueryDeletedOption;
import com.microsoft.alm.teamfoundation.build.webapi.Timeline;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.ResourceRef;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class BuildHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected BuildHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, artifact, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, String project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, artifact, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public BuildArtifact createArtifact(BuildArtifact artifact, UUID project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, artifact, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(String project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(UUID project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public BuildArtifact getArtifact(int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildArtifact.class);
    }

    public InputStream getArtifactContentZip(String project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getArtifactContentZip(UUID project, int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getArtifactContentZip(int buildId, String artifactName) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactName", artifactName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<BuildArtifact> getArtifacts(int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildArtifact>>(){});
    }

    public ArrayList<BuildArtifact> getArtifacts(String project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildArtifact>>(){});
    }

    public ArrayList<BuildArtifact> getArtifacts(UUID project, int buildId) {
        UUID locationId = UUID.fromString("1db06c96-014e-44e1-ac91-90b2d4b3e984");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildArtifact>>(){});
    }

    public String getBadge(UUID project, int definitionId, String branchName) {
        UUID locationId = UUID.fromString("de6a4df8-22cd-44ee-af2d-39f6aa7a4261");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("branchName", branchName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, String.class);
    }

    public BuildBadge getBuildBadge(String project, String repoType, String repoId, String branchName) {
        UUID locationId = UUID.fromString("21b3b9ce-fad5-4567-9ad0-80679794e003");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repoType", repoType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repoId", repoId);
        queryParameters.addIfNotEmpty("branchName", branchName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildBadge.class);
    }

    public BuildBadge getBuildBadge(UUID project, String repoType, String repoId, String branchName) {
        UUID locationId = UUID.fromString("21b3b9ce-fad5-4567-9ad0-80679794e003");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repoType", repoType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repoId", repoId);
        queryParameters.addIfNotEmpty("branchName", branchName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildBadge.class);
    }

    public String getBuildBadgeData(String project, String repoType, String repoId, String branchName) {
        UUID locationId = UUID.fromString("21b3b9ce-fad5-4567-9ad0-80679794e003");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repoType", repoType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repoId", repoId);
        queryParameters.addIfNotEmpty("branchName", branchName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, String.class);
    }

    public String getBuildBadgeData(UUID project, String repoType, String repoId, String branchName) {
        UUID locationId = UUID.fromString("21b3b9ce-fad5-4567-9ad0-80679794e003");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("repoType", repoType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("repoId", repoId);
        queryParameters.addIfNotEmpty("branchName", branchName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, String.class);
    }

    public void deleteBuild(int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteBuild(String project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteBuild(UUID project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public Build getBuild(String project, int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build getBuild(UUID project, int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build getBuild(int buildId, String propertyFilters) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public ArrayList<Build> getBuilds(String project, List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder, String branchName, List<Integer> buildIds, String repositoryId, String repositoryType) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", reasonFilter);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("resultFilter", resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", deletedFilter);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotEmpty("branchName", branchName);
        queryParameters.addIfNotNull("buildIds", buildIds);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public ArrayList<Build> getBuilds(UUID project, List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder, String branchName, List<Integer> buildIds, String repositoryId, String repositoryType) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", reasonFilter);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("resultFilter", resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", deletedFilter);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotEmpty("branchName", branchName);
        queryParameters.addIfNotNull("buildIds", buildIds);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public ArrayList<Build> getBuilds(List<Integer> definitions, List<Integer> queues, String buildNumber, Date minFinishTime, Date maxFinishTime, String requestedFor, BuildReason reasonFilter, BuildStatus statusFilter, BuildResult resultFilter, List<String> tagFilters, List<String> properties, Integer top, String continuationToken, Integer maxBuildsPerDefinition, QueryDeletedOption deletedFilter, BuildQueryOrder queryOrder, String branchName, List<Integer> buildIds, String repositoryId, String repositoryType) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitions", definitions);
        queryParameters.addIfNotNull("queues", queues);
        queryParameters.addIfNotEmpty("buildNumber", buildNumber);
        queryParameters.addIfNotNull("minFinishTime", minFinishTime);
        queryParameters.addIfNotNull("maxFinishTime", maxFinishTime);
        queryParameters.addIfNotEmpty("requestedFor", requestedFor);
        queryParameters.addIfNotNull("reasonFilter", reasonFilter);
        queryParameters.addIfNotNull("statusFilter", statusFilter);
        queryParameters.addIfNotNull("resultFilter", resultFilter);
        queryParameters.addIfNotNull("tagFilters", tagFilters);
        queryParameters.addIfNotNull("properties", properties);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("maxBuildsPerDefinition", maxBuildsPerDefinition);
        queryParameters.addIfNotNull("deletedFilter", deletedFilter);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotEmpty("branchName", branchName);
        queryParameters.addIfNotNull("buildIds", buildIds);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public Build queueBuild(Build build, Boolean ignoreWarnings, String checkInTicket) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", ignoreWarnings);
        queryParameters.addIfNotEmpty("checkInTicket", checkInTicket);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, build, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build queueBuild(Build build, String project, Boolean ignoreWarnings, String checkInTicket) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", ignoreWarnings);
        queryParameters.addIfNotEmpty("checkInTicket", checkInTicket);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, build, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build queueBuild(Build build, UUID project, Boolean ignoreWarnings, String checkInTicket) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ignoreWarnings", ignoreWarnings);
        queryParameters.addIfNotEmpty("checkInTicket", checkInTicket);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, build, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build updateBuild(Build build, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, build, "application/json", "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build updateBuild(Build build, String project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, build, "application/json", "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public Build updateBuild(Build build, UUID project, int buildId) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, build, "application/json", "application/json");
        return super.sendRequest(httpRequest, Build.class);
    }

    public ArrayList<Build> updateBuilds(List<Build> builds) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, apiVersion, builds, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public ArrayList<Build> updateBuilds(List<Build> builds, String project) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, builds, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public ArrayList<Build> updateBuilds(List<Build> builds, UUID project) {
        UUID locationId = UUID.fromString("0cd358e1-9217-4d94-8269-1c1ee6f93dcf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, builds, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Build>>(){});
    }

    public ArrayList<Change> getBuildChanges(String project, int buildId, String continuationToken, Integer top, Boolean includeSourceChange) {
        UUID locationId = UUID.fromString("54572c7b-bbd3-45d4-80dc-28be08941620");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeSourceChange", includeSourceChange);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public ArrayList<Change> getBuildChanges(UUID project, int buildId, String continuationToken, Integer top, Boolean includeSourceChange) {
        UUID locationId = UUID.fromString("54572c7b-bbd3-45d4-80dc-28be08941620");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("includeSourceChange", includeSourceChange);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public ArrayList<Change> getChangesBetweenBuilds(String project, Integer fromBuildId, Integer toBuildId, Integer top) {
        UUID locationId = UUID.fromString("f10f0ea5-18a1-43ec-a8fb-2042c7be9b43");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fromBuildId", fromBuildId);
        queryParameters.addIfNotNull("toBuildId", toBuildId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public ArrayList<Change> getChangesBetweenBuilds(UUID project, Integer fromBuildId, Integer toBuildId, Integer top) {
        UUID locationId = UUID.fromString("f10f0ea5-18a1-43ec-a8fb-2042c7be9b43");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fromBuildId", fromBuildId);
        queryParameters.addIfNotNull("toBuildId", toBuildId);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Change>>(){});
    }

    public BuildController getBuildController(int controllerId) {
        UUID locationId = UUID.fromString("fcac1932-2ee1-437f-9b6f-7f696be858f6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("controllerId", controllerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BuildController.class);
    }

    public ArrayList<BuildController> getBuildControllers(String name) {
        UUID locationId = UUID.fromString("fcac1932-2ee1-437f-9b6f-7f696be858f6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildController>>(){});
    }

    public BuildDefinition createDefinition(BuildDefinition definition, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", definitionToCloneRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition createDefinition(BuildDefinition definition, String project, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", definitionToCloneRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition createDefinition(BuildDefinition definition, UUID project, Integer definitionToCloneId, Integer definitionToCloneRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("definitionToCloneId", definitionToCloneId);
        queryParameters.addIfNotNull("definitionToCloneRevision", definitionToCloneRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public void deleteDefinition(int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteDefinition(String project, int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteDefinition(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public BuildDefinition getDefinition(String project, int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition getDefinition(UUID project, int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition getDefinition(int definitionId, Integer revision, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("revision", revision);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public ArrayList<BuildDefinitionReference> getDefinitions(String project, String name, String repositoryId, String repositoryType, DefinitionQueryOrder queryOrder, Integer top, String continuationToken, Date minMetricsTime, List<Integer> definitionIds, String path, Date builtAfter, Date notBuiltAfter) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("minMetricsTime", minMetricsTime);
        queryParameters.addIfNotNull("definitionIds", definitionIds);
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("builtAfter", builtAfter);
        queryParameters.addIfNotNull("notBuiltAfter", notBuiltAfter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionReference>>(){});
    }

    public ArrayList<BuildDefinitionReference> getDefinitions(UUID project, String name, String repositoryId, String repositoryType, DefinitionQueryOrder queryOrder, Integer top, String continuationToken, Date minMetricsTime, List<Integer> definitionIds, String path, Date builtAfter, Date notBuiltAfter) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("minMetricsTime", minMetricsTime);
        queryParameters.addIfNotNull("definitionIds", definitionIds);
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("builtAfter", builtAfter);
        queryParameters.addIfNotNull("notBuiltAfter", notBuiltAfter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionReference>>(){});
    }

    public ArrayList<BuildDefinitionReference> getDefinitions(String name, String repositoryId, String repositoryType, DefinitionQueryOrder queryOrder, Integer top, String continuationToken, Date minMetricsTime, List<Integer> definitionIds, String path, Date builtAfter, Date notBuiltAfter) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("name", name);
        queryParameters.addIfNotEmpty("repositoryId", repositoryId);
        queryParameters.addIfNotEmpty("repositoryType", repositoryType);
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("minMetricsTime", minMetricsTime);
        queryParameters.addIfNotNull("definitionIds", definitionIds);
        queryParameters.addIfNotEmpty("path", path);
        queryParameters.addIfNotNull("builtAfter", builtAfter);
        queryParameters.addIfNotNull("notBuiltAfter", notBuiltAfter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionReference>>(){});
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", secretsSourceDefinitionRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, String project, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", secretsSourceDefinitionRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, UUID project, int definitionId, Integer secretsSourceDefinitionId, Integer secretsSourceDefinitionRevision) {
        UUID locationId = UUID.fromString("dbeaf647-6167-421a-bda9-c9327b25e2e6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("secretsSourceDefinitionId", secretsSourceDefinitionId);
        queryParameters.addIfNotNull("secretsSourceDefinitionRevision", secretsSourceDefinitionRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, definition, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildDefinition.class);
    }

    public Folder createFolder(Folder folder, String project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, folder, "application/json", "application/json");
        return super.sendRequest(httpRequest, Folder.class);
    }

    public Folder createFolder(Folder folder, UUID project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, folder, "application/json", "application/json");
        return super.sendRequest(httpRequest, Folder.class);
    }

    public void deleteFolder(String project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteFolder(UUID project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<Folder> getFolders(String project, String path, FolderQueryOrder queryOrder) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Folder>>(){});
    }

    public ArrayList<Folder> getFolders(UUID project, String path, FolderQueryOrder queryOrder) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("queryOrder", queryOrder);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Folder>>(){});
    }

    public Folder updateFolder(Folder folder, String project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, folder, "application/json", "application/json");
        return super.sendRequest(httpRequest, Folder.class);
    }

    public Folder updateFolder(Folder folder, UUID project, String path) {
        UUID locationId = UUID.fromString("a906531b-d2da-4f55-bda7-f3e676cc50d9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, folder, "application/json", "application/json");
        return super.sendRequest(httpRequest, Folder.class);
    }

    public InputStream getBuildLog(String project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", startLine);
        queryParameters.addIfNotNull("endLine", endLine);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBuildLog(UUID project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", startLine);
        queryParameters.addIfNotNull("endLine", endLine);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/plaint");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<String> getBuildLogLines(String project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", startLine);
        queryParameters.addIfNotNull("endLine", endLine);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getBuildLogLines(UUID project, int buildId, int logId, Integer startLine, Integer endLine) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("logId", logId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startLine", startLine);
        queryParameters.addIfNotNull("endLine", endLine);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<BuildLog> getBuildLogs(String project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildLog>>(){});
    }

    public ArrayList<BuildLog> getBuildLogs(UUID project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildLog>>(){});
    }

    public InputStream getBuildLogsZip(String project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBuildLogsZip(UUID project, int buildId) {
        UUID locationId = UUID.fromString("35a80daf-7f30-45fc-86e8-6b813d9c90df");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<BuildMetric> getDefinitionMetrics(String project, int definitionId, Date minMetricsTime) {
        UUID locationId = UUID.fromString("d973b939-0ce0-4fec-91d8-da3940fa1827");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("minMetricsTime", minMetricsTime);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildMetric>>(){});
    }

    public ArrayList<BuildMetric> getDefinitionMetrics(UUID project, int definitionId, Date minMetricsTime) {
        UUID locationId = UUID.fromString("d973b939-0ce0-4fec-91d8-da3940fa1827");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("minMetricsTime", minMetricsTime);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildMetric>>(){});
    }

    public ArrayList<BuildOptionDefinition> getBuildOptionDefinitions() {
        UUID locationId = UUID.fromString("591cb5a4-2d46-4f3a-a697-5cd42b6bd332");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildOptionDefinition>>(){});
    }

    public ArrayList<BuildOptionDefinition> getBuildOptionDefinitions(String project) {
        UUID locationId = UUID.fromString("591cb5a4-2d46-4f3a-a697-5cd42b6bd332");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildOptionDefinition>>(){});
    }

    public ArrayList<BuildOptionDefinition> getBuildOptionDefinitions(UUID project) {
        UUID locationId = UUID.fromString("591cb5a4-2d46-4f3a-a697-5cd42b6bd332");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildOptionDefinition>>(){});
    }

    public BuildReportMetadata getBuildReport(String project, int buildId, String type) {
        UUID locationId = UUID.fromString("45bcaa88-67e1-4042-a035-56d3b4a7d44c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildReportMetadata.class);
    }

    public BuildReportMetadata getBuildReport(UUID project, int buildId, String type) {
        UUID locationId = UUID.fromString("45bcaa88-67e1-4042-a035-56d3b4a7d44c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, BuildReportMetadata.class);
    }

    public InputStream getBuildReportHtmlContent(String project, int buildId, String type) {
        UUID locationId = UUID.fromString("45bcaa88-67e1-4042-a035-56d3b4a7d44c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/html");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getBuildReportHtmlContent(UUID project, int buildId, String type) {
        UUID locationId = UUID.fromString("45bcaa88-67e1-4042-a035-56d3b4a7d44c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "text/html");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public BuildResourceUsage getResourceUsage() {
        UUID locationId = UUID.fromString("3813d06c-9e36-4ea1-aac3-61a485d60e3d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BuildResourceUsage.class);
    }

    public ArrayList<BuildDefinitionRevision> getDefinitionRevisions(String project, int definitionId) {
        UUID locationId = UUID.fromString("7c116775-52e5-453e-8c5d-914d9762d8c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionRevision>>(){});
    }

    public ArrayList<BuildDefinitionRevision> getDefinitionRevisions(UUID project, int definitionId) {
        UUID locationId = UUID.fromString("7c116775-52e5-453e-8c5d-914d9762d8c4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("definitionId", definitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionRevision>>(){});
    }

    public BuildSettings getBuildSettings() {
        UUID locationId = UUID.fromString("aa8c1c9c-ef8b-474a-b8c4-785c7b191d0d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BuildSettings.class);
    }

    public BuildSettings updateBuildSettings(BuildSettings settings) {
        UUID locationId = UUID.fromString("aa8c1c9c-ef8b-474a-b8c4-785c7b191d0d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, apiVersion, settings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildSettings.class);
    }

    public ArrayList<String> addBuildTag(String project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> addBuildTag(UUID project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> addBuildTags(List<String> tags, String project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, tags, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> addBuildTags(List<String> tags, UUID project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, tags, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> deleteBuildTag(String project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> deleteBuildTag(UUID project, int buildId, String tag) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("tag", tag);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getBuildTags(String project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getBuildTags(UUID project, int buildId) {
        UUID locationId = UUID.fromString("6e6114b2-8161-44c8-8f6c-c5505782427f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getTags(String project) {
        UUID locationId = UUID.fromString("d84ac5c6-edc7-43d5-adc9-1b34be5dea09");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> getTags(UUID project) {
        UUID locationId = UUID.fromString("d84ac5c6-edc7-43d5-adc9-1b34be5dea09");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public void deleteTemplate(String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTemplate(UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public BuildDefinitionTemplate getTemplate(String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BuildDefinitionTemplate.class);
    }

    public BuildDefinitionTemplate getTemplate(UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BuildDefinitionTemplate.class);
    }

    public ArrayList<BuildDefinitionTemplate> getTemplates(String project) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionTemplate>>(){});
    }

    public ArrayList<BuildDefinitionTemplate> getTemplates(UUID project) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BuildDefinitionTemplate>>(){});
    }

    public BuildDefinitionTemplate saveTemplate(BuildDefinitionTemplate template, String project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildDefinitionTemplate.class);
    }

    public BuildDefinitionTemplate saveTemplate(BuildDefinitionTemplate template, UUID project, String templateId) {
        UUID locationId = UUID.fromString("e884571e-7f92-4d6a-9274-3f5649900835");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, BuildDefinitionTemplate.class);
    }

    public Timeline getBuildTimeline(String project, int buildId, UUID timelineId, Integer changeId, UUID planId) {
        UUID locationId = UUID.fromString("8baac422-4c6e-4de5-8532-db96d92acffa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", changeId);
        queryParameters.addIfNotNull("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Timeline.class);
    }

    public Timeline getBuildTimeline(UUID project, int buildId, UUID timelineId, Integer changeId, UUID planId) {
        UUID locationId = UUID.fromString("8baac422-4c6e-4de5-8532-db96d92acffa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        routeValues.put("timelineId", timelineId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("changeId", changeId);
        queryParameters.addIfNotNull("planId", planId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Timeline.class);
    }

    public ArrayList<ResourceRef> getBuildWorkItemsRefs(String project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }

    public ArrayList<ResourceRef> getBuildWorkItemsRefs(UUID project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }

    public ArrayList<ResourceRef> getBuildWorkItemsRefsFromCommits(List<String> commitIds, String project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commitIds, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }

    public ArrayList<ResourceRef> getBuildWorkItemsRefsFromCommits(List<String> commitIds, UUID project, int buildId, Integer top) {
        UUID locationId = UUID.fromString("5a21f5d2-5642-47e4-a0bd-1356e6731bee");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("buildId", buildId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, commitIds, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }

    public ArrayList<ResourceRef> getWorkItemsBetweenBuilds(String project, int fromBuildId, int toBuildId, Integer top) {
        UUID locationId = UUID.fromString("52ba8915-5518-42e3-a4bb-b0182d159e2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("fromBuildId", String.valueOf(fromBuildId));
        queryParameters.put("toBuildId", String.valueOf(toBuildId));
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }

    public ArrayList<ResourceRef> getWorkItemsBetweenBuilds(UUID project, int fromBuildId, int toBuildId, Integer top) {
        UUID locationId = UUID.fromString("52ba8915-5518-42e3-a4bb-b0182d159e2d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("fromBuildId", String.valueOf(fromBuildId));
        queryParameters.put("toBuildId", String.valueOf(toBuildId));
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ResourceRef>>(){});
    }
}

