/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.distributedtask.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.JobAssignedEvent;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.JobCompletedEvent;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.JobEvent;
import java.io.IOException;

public class JobEventDeserializer
extends JsonDeserializer<JobEvent> {
    public JobEvent deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode requestNode;
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode nameNode = rootNode.findValue("Name");
        if (nameNode != null) {
            if (nameNode.isTextual() && "JobAssigned".equals(nameNode.asText())) {
                return (JobEvent)rootNode.traverse((ObjectCodec)mapper).readValueAs(JobAssignedEvent.class);
            }
            if (nameNode.isTextual() && "JobCompleted".equals(nameNode.asText())) {
                return (JobEvent)rootNode.traverse((ObjectCodec)mapper).readValueAs(JobCompletedEvent.class);
            }
        }
        if ((requestNode = rootNode.findValue("Request")) != null) {
            return (JobEvent)rootNode.traverse((ObjectCodec)mapper).readValueAs(JobAssignedEvent.class);
        }
        JsonNode resultNode = rootNode.findValue("Result");
        if (resultNode != null) {
            return (JobEvent)rootNode.traverse((ObjectCodec)mapper).readValueAs(JobCompletedEvent.class);
        }
        return null;
    }
}

