/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildInformation;
import com.microsoft.tfs.core.clients.build.IBuildInformationNode;
import com.microsoft.tfs.core.clients.build.InformationNodeConverters;
import com.microsoft.tfs.core.clients.build.flags.InformationEditOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformation;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNodeComparer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationAddRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationDeleteRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationEditRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationField;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ms.tfs.build.buildservice._04._BuildInformationNode;
import ms.tfs.build.buildservice._04._InformationField;

public class BuildInformationNode
extends WebServiceObjectWrapper
implements IBuildInformationNode,
Comparable<BuildInformationNode> {
    BuildDetail build;
    BuildInformation children;
    Map<String, String> fields;
    Map<String, String> lastSnapshot;
    BuildInformationNode parent;
    BuildInformation owner;
    Object lock = new Object();
    Object lockFields = new Object();
    private static int s_nextTempID = 0;
    private static Object s_lockTempID = new Object();

    private BuildInformationNode() {
        super(new _BuildInformationNode());
        this.getWebServiceObject().setFields(new _InformationField[0]);
        this.getWebServiceObject().setLastModifiedDate(DotNETDate.MIN_CALENDAR);
    }

    public BuildInformationNode(_BuildInformationNode webServiceObject) {
        super(webServiceObject);
        this.afterDeserialize();
    }

    public BuildInformationNode(BuildDetail build, BuildInformationNode parent) {
        this();
        this.setID(BuildInformationNode.getNextTempID());
        this.build = build;
        this.parent = parent;
        if (parent != null) {
            this.owner = (BuildInformation)parent.getChildren();
        }
    }

    public BuildInformationNode(BuildDetail build, BuildInformation collection) {
        this(build, (BuildInformationNode)null);
        this.owner = collection;
    }

    public BuildInformationNode(BuildInformationNode2010 node2010) {
        this();
        this.getWebServiceObject().setFields((_InformationField[])WrapperUtils.unwrap(_InformationField.class, TFS2010Helper.convert(node2010.getInternalFields())));
        this.getWebServiceObject().setLastModifiedBy(node2010.getLastModifiedBy());
        this.getWebServiceObject().setLastModifiedDate(node2010.getLastModifiedDate());
        this.getWebServiceObject().setNodeId(node2010.getNodeID());
        this.getWebServiceObject().setParentId(node2010.getParentID());
        this.getWebServiceObject().setType(node2010.getType());
        this.afterDeserialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDeserialize() {
        this.fields = this.informationFieldsToDictionary(this.getInternalFields());
        Object object = this.lockFields;
        synchronized (object) {
            this.lastSnapshot = this.copyDictionary(this.getFields());
        }
    }

    public _BuildInformationNode getWebServiceObject() {
        return (_BuildInformationNode)this.webServiceObject;
    }

    public InformationField[] getInternalFields() {
        return (InformationField[])WrapperUtils.wrap(InformationField.class, this.getWebServiceObject().getFields());
    }

    @Override
    public String getLastModifiedBy() {
        return this.getWebServiceObject().getLastModifiedBy();
    }

    @Override
    public Calendar getLastModifiedDate() {
        return this.getWebServiceObject().getLastModifiedDate();
    }

    public int getNodeID() {
        return this.getWebServiceObject().getNodeId();
    }

    public void setNodeID(int value) {
        this.getWebServiceObject().setNodeId(value);
    }

    public int getParentID() {
        return this.getWebServiceObject().getParentId();
    }

    public void setParentID(int value) {
        this.getWebServiceObject().setParentId(value);
    }

    @Override
    public String getType() {
        return this.getWebServiceObject().getType();
    }

    @Override
    public void setType(String value) {
        this.getWebServiceObject().setType(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBuildInformation getChildren() {
        if (this.children == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.children == null) {
                    this.children = new BuildInformation(this.build, this);
                }
            }
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFields() {
        Object object = this.lockFields;
        synchronized (object) {
            if (this.fields == null) {
                this.fields = new TreeMap<String, String>();
            }
            return this.fields;
        }
    }

    @Override
    public int getID() {
        return this.getWebServiceObject().getNodeId();
    }

    public void setID(int value) {
        this.getWebServiceObject().setNodeId(value);
    }

    @Override
    public IBuildInformationNode getParent() {
        return this.parent;
    }

    public void setParent(IBuildInformationNode value) {
        this.parent = (BuildInformationNode)value;
        if (this.parent == null) {
            this.getWebServiceObject().setParentId(0);
        } else {
            this.getWebServiceObject().setParentId(value.getID());
        }
    }

    @Override
    public void delete() {
        if (this.getID() > 0) {
            InformationDeleteRequest request = new InformationDeleteRequest();
            request.setBuildURI(this.build.getURI());
            request.setNodeID(this.getID());
            if (this.build.getBuildServer().getBuildServerVersion().isV2()) {
                this.build.getInternalBuildServer().getBuild2008Helper().updateBuildInformation(new InformationChangeRequest[]{request});
            } else if (this.build.getBuildServer().getBuildServerVersion().isV3()) {
                this.build.getInternalBuildServer().getBuild2010Helper().updateBuildInformation(new InformationChangeRequest[]{request});
            } else {
                this.build.getInternalBuildServer().getBuildService().updateBuildInformation(new InformationChangeRequest[]{request});
            }
        }
        this.owner.deleteNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.build.syncSave;
        synchronized (object) {
            InformationNodeConverters.bulkUpdateInformationNodes(this.build, this.getRequests(true));
        }
    }

    @Override
    public int compareTo(BuildInformationNode node) {
        return BuildInformationNodeComparer.getInstance().compare(this, node);
    }

    public BuildDetail getBuild() {
        return this.build;
    }

    public void setBuild(BuildDetail value) {
        this.build = value;
    }

    public boolean isDirty() {
        if (this.fields.size() != this.lastSnapshot.size()) {
            return true;
        }
        for (Map.Entry<String, String> entry : this.getFields().entrySet()) {
            String snapshotValue = this.lastSnapshot.get(entry.getKey());
            if (snapshotValue != null && snapshotValue.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InformationAddRequest createAddRequest() {
        Object object = this.lockFields;
        synchronized (object) {
            this.lastSnapshot = this.copyDictionary(this.getFields());
        }
        InformationAddRequest addRequest = new InformationAddRequest();
        addRequest.setBuildURI(this.build.getURI());
        addRequest.setFields(this.dictionaryToInformationFields(this.lastSnapshot));
        addRequest.setNodeID(this.getID());
        addRequest.setNodeType(this.getType());
        if (this.getParent() != null) {
            addRequest.setParentID(this.parent.getID());
        }
        addRequest.setNode(this);
        return addRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InformationChangeRequest> getRequests(boolean getUnsavedParentNodes) {
        Object unsavedParent;
        ArrayList<InformationChangeRequest> result = new ArrayList<InformationChangeRequest>();
        if (this.getID() < 0) {
            if (getUnsavedParentNodes) {
                for (unsavedParent = this.getParent(); unsavedParent != null && unsavedParent.getID() < 0; unsavedParent = unsavedParent.getParent()) {
                    result.add(((BuildInformationNode)unsavedParent).createAddRequest());
                }
            }
            result.add(this.createAddRequest());
        } else if (this.isDirty()) {
            unsavedParent = this.lockFields;
            synchronized (unsavedParent) {
                this.lastSnapshot = this.copyDictionary(this.getFields());
            }
            InformationEditRequest editRequest = new InformationEditRequest();
            editRequest.setBuildURI(this.build.getURI());
            editRequest.setFields(this.dictionaryToInformationFields(this.lastSnapshot));
            editRequest.setNodeID(this.getID());
            editRequest.setOptions(InformationEditOptions.REPLACE_FIELDS);
            result.add(editRequest);
        }
        for (IBuildInformationNode node : this.getChildren().getNodes()) {
            result.addAll(((BuildInformationNode)node).getRequests(false));
        }
        return result;
    }

    private Map<String, String> informationFieldsToDictionary(InformationField[] fields) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (InformationField field : fields) {
            result.put(field.getName(), field.getValue());
        }
        return result;
    }

    private InformationField[] dictionaryToInformationFields(Map<String, String> map) {
        ArrayList<InformationField> fieldList = new ArrayList<InformationField>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                fieldList.add(new InformationField(entry.getKey(), entry.getValue()));
            }
        }
        return fieldList.toArray(new InformationField[fieldList.size()]);
    }

    private Map<String, String> copyDictionary(Map<String, String> map) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public BuildInformation getOwner() {
        return this.owner;
    }

    public void setOwner(BuildInformation value) {
        this.owner = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextTempID() {
        Object object = s_lockTempID;
        synchronized (object) {
            return --s_nextTempID;
        }
    }
}

