/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTableLock;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LocalMetadataTable
implements Closeable {
    private static final Log log = LogFactory.getLog(LocalMetadataTable.class);
    protected static final String FILE_EXTENSION_SLOT_ONE = ".tf1";
    protected static final String FILE_EXTENSION_SLOT_TWO = ".tf2";
    protected static final String FILE_EXTENSION_SLOT_THREE = ".tf3";
    private boolean dirty;
    private boolean aborted;
    private boolean eligibleForCachedLoad;
    private final String filename;
    private FileSystemAttributes savedAttributes;
    private LocalMetadataTableLock tableLock;

    public LocalMetadataTable(String fileName) throws IOException {
        this(fileName, null, 7);
    }

    public LocalMetadataTable(String fileName, LocalMetadataTable cachedLoadSource) throws IOException {
        this(fileName, cachedLoadSource, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalMetadataTable(String filename, LocalMetadataTable cachedLoadSource, int retryCount) throws IOException {
        Check.notNull(filename, "filename");
        this.filename = filename;
        this.setDirty(false);
        this.setAborted(false);
        try {
            this.tableLock = new LocalMetadataTableLock(filename, retryCount, false);
            this.recover();
            this.initialize();
            log.debug((Object)MessageFormat.format("Loading {0}", this.getClass().getCanonicalName()));
            long start = System.currentTimeMillis();
            if (!this.tryCachedLoad(cachedLoadSource)) {
                FileInputStream is = null;
                BufferedInputStream bis = null;
                try {
                    is = this.getInputStream();
                    if (is != null) {
                        bis = new BufferedInputStream(is);
                        this.load(bis);
                    }
                }
                finally {
                    if (bis != null) {
                        bis.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
            }
            log.debug((Object)MessageFormat.format("Total time for load of {0} was {1} ms", this.getClass().getName(), System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            this.close(false);
            throw new VersionControlException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean disposing) throws IOException {
        block15: {
            try {
                block18: {
                    FilterOutputStream bos;
                    FileOutputStream os;
                    long start;
                    block16: {
                        if (!disposing || this.tableLock == null) break block15;
                        if (!this.isDirty() || this.isAborted()) break block18;
                        log.debug((Object)MessageFormat.format("Saving {0}", this.getClass().getName()));
                        start = System.currentTimeMillis();
                        boolean keepFile = true;
                        os = null;
                        bos = null;
                        try {
                            os = this.getOutputStream();
                            if (os == null) break block16;
                            bos = new BufferedOutputStream(os);
                            this.save(bos);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (bos != null) {
                                    bos.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                            catch (IOException e) {
                                log.error((Object)MessageFormat.format("Could not close {0}", this.getClass().getCanonicalName()), (Throwable)e);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)MessageFormat.format("Could not close {0}", this.getClass().getCanonicalName()), (Throwable)e);
                    }
                    this.positionFile(true);
                    log.debug((Object)MessageFormat.format("Total time for save of {0} was {1} ms", this.getClass().getName(), System.currentTimeMillis() - start));
                    this.setDirty(false);
                    this.saveComplete();
                    this.makeEligibleForCachedLoad();
                    break block15;
                }
                if (!this.isDirty()) {
                    this.makeEligibleForCachedLoad();
                }
            }
            finally {
                if (this.tableLock != null) {
                    this.tableLock.close();
                }
            }
        }
    }

    private void makeEligibleForCachedLoad() {
        this.savedAttributes = FileSystemUtils.getInstance().getAttributes(LocalMetadataTable.getSlotOnePath(this.filename));
        this.setEligibleForCachedLoad(true);
    }

    protected abstract void load(InputStream var1) throws Exception;

    protected abstract boolean save(OutputStream var1) throws IOException;

    protected void initialize() {
    }

    protected void saveComplete() {
    }

    protected boolean cachedLoad(LocalMetadataTable source) {
        return false;
    }

    private boolean tryCachedLoad(LocalMetadataTable source) {
        if (source != null) {
            source.setEligibleForCachedLoad(false);
            FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(LocalMetadataTable.getSlotOnePath(this.filename));
            FileSystemAttributes sourceSavedAttributes = source.getSavedAttributes();
            Check.notNull(attrs, "attrs");
            Check.notNull(sourceSavedAttributes, "sourceSavedAttributes");
            if (!attrs.exists()) {
                source = null;
                return this.cachedLoad(source);
            }
            if (attrs.getSize() == sourceSavedAttributes.getSize() && attrs.getModificationTime().equals(sourceSavedAttributes.getModificationTime())) {
                return this.cachedLoad(source);
            }
        }
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        Check.isTrue(!this.isAborted(), "We should not be modifying dirty state if we are aborted");
        this.dirty = dirty;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isEligibleForCachedLoad() {
        return this.eligibleForCachedLoad;
    }

    public void setEligibleForCachedLoad(boolean eligibleForCachedLoad) {
        this.eligibleForCachedLoad = eligibleForCachedLoad;
    }

    private void recover() {
        String slotOneFilename = LocalMetadataTable.getSlotOnePath(this.filename);
        String slotTwoFilename = LocalMetadataTable.getSlotTwoPath(this.filename);
        File slotTwoFile = new File(slotTwoFilename);
        if (slotTwoFile.exists()) {
            File slotOneFile = new File(slotOneFilename);
            if (slotOneFile.exists()) {
                slotTwoFile.delete();
            } else {
                FileHelpers.renameWithoutException(slotTwoFile, slotOneFile);
            }
        }
    }

    private void positionFile(boolean keepFile) {
        String slotOneFilename = LocalMetadataTable.getSlotOnePath(this.filename);
        String slotTwoFilename = LocalMetadataTable.getSlotTwoPath(this.filename);
        String slotThreeFilename = LocalMetadataTable.getSlotThreePath(this.filename);
        File slotOneFile = new File(slotOneFilename);
        File slotTwoFile = new File(slotTwoFilename);
        File slotThreeFile = new File(slotThreeFilename);
        slotTwoFile.delete();
        if (!FileHelpers.renameWithoutException(slotThreeFile, slotTwoFile)) {
            throw new RuntimeException(MessageFormat.format("Could not rename {0} to {1}", slotThreeFilename, slotTwoFilename));
        }
        slotOneFile.delete();
        FileHelpers.renameWithoutException(slotTwoFile, slotOneFile);
    }

    private FileInputStream getInputStream() {
        try {
            return new FileInputStream(new File(LocalMetadataTable.getSlotOnePath(this.filename)));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private FileOutputStream getOutputStream() {
        File slotThreeFile = new File(LocalMetadataTable.getSlotThreePath(this.filename));
        try {
            if (!slotThreeFile.exists() && slotThreeFile.getParent() != null) {
                FileHelpers.createDirectoryIfNecessary(slotThreeFile.getParent());
            }
            return new FileOutputStream(slotThreeFile);
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Could not open file {0} for writing", slotThreeFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    public static String getSlotOnePath(String filename) {
        return filename + FILE_EXTENSION_SLOT_ONE;
    }

    public static String getSlotTwoPath(String filename) {
        return filename + FILE_EXTENSION_SLOT_TWO;
    }

    public static String getSlotThreePath(String filename) {
        return filename + FILE_EXTENSION_SLOT_THREE;
    }

    public FileSystemAttributes getSavedAttributes() {
        return this.savedAttributes;
    }

    protected String getFilename() {
        return this.filename;
    }
}

