/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SecurityChange;
import com.microsoft.tfs.util.Check;
import ms.tfs.versioncontrol.clientservices._03._PermissionChange;

public abstract class PermissionChange
extends SecurityChange {
    public static final String GLOBAL_PERMISSION_ADMIN_CONFIGURATION = "AdminConfiguration";
    public static final String GLOBAL_PERMISSION_ADMIN_CONNECTIONS = "AdminConnections";
    public static final String GLOBAL_PERMISSION_ADMIN_SHELVESETS = "AdminShelvesets";
    public static final String GLOBAL_PERMISSION_ADMIN_WORKSPACES = "AdminWorkspaces";
    public static final String GLOBAL_PERMISSION_CREATE_WORKSPACE = "CreateWorkspace";
    public static final String ITEM_PERMISSION_ADMIN_PROJECT_RIGHTS = "AdminProjectRights";
    public static final String ITEM_PERMISSION_CHECKIN = "Checkin";
    public static final String ITEM_PERMISSION_CHECKIN_OTHER = "CheckinOther";
    public static final String ITEM_PERMISSION_LABEL = "Label";
    public static final String ITEM_PERMISSION_LABEL_OTHER = "LabelOther";
    public static final String ITEM_PERMISSION_LOCK = "Lock";
    public static final String ITEM_PERMISSION_MANAGE_BRANCH = "ManageBranch";
    public static final String ITEM_PERMISSION_MERGE = "Merge";
    public static final String ITEM_PERMISSION_PEND_CHANGE = "PendChange";
    public static final String ITEM_PERMISSION_READ = "Read";
    public static final String ITEM_PERMISSION_REVISE_OTHER = "ReviseOther";
    public static final String ITEM_PERMISSION_UNDO_OTHER = "UndoOther";
    public static final String ITEM_PERMISSION_UNLOCK_OTHER = "UnlockOther";

    public static final String[] getAllGlobalPermissions() {
        return new String[]{GLOBAL_PERMISSION_CREATE_WORKSPACE, GLOBAL_PERMISSION_ADMIN_WORKSPACES, GLOBAL_PERMISSION_ADMIN_SHELVESETS, GLOBAL_PERMISSION_ADMIN_CONNECTIONS, GLOBAL_PERMISSION_ADMIN_CONFIGURATION};
    }

    public static final String[] getAllGlobalLocalizedPermissions() {
        return new String[]{Messages.getString("PermissionChange.CreateAWorkspace"), Messages.getString("PermissionChange.AdministerWorkspaces"), Messages.getString("PermissionChange.AdministerShelvedChanges"), Messages.getString("PermissionChange.AdministerSourceControlConnections"), Messages.getString("PermissionChange.AdministerSourceControlConfigurations")};
    }

    public static final String[] getAllItemPermissions() {
        return new String[]{ITEM_PERMISSION_READ, ITEM_PERMISSION_PEND_CHANGE, ITEM_PERMISSION_CHECKIN, ITEM_PERMISSION_LABEL, ITEM_PERMISSION_LOCK, ITEM_PERMISSION_REVISE_OTHER, ITEM_PERMISSION_UNLOCK_OTHER, ITEM_PERMISSION_UNDO_OTHER, ITEM_PERMISSION_LABEL_OTHER, ITEM_PERMISSION_ADMIN_PROJECT_RIGHTS, ITEM_PERMISSION_CHECKIN_OTHER, ITEM_PERMISSION_MERGE, ITEM_PERMISSION_MANAGE_BRANCH};
    }

    public static final String[] getAllLocalizedItemPermissions() {
        return new String[]{Messages.getString("PermissionChange.Read"), Messages.getString("PermissionChange.CheckOut"), Messages.getString("PermissionChange.CheckIn"), Messages.getString("PermissionChange.Label"), Messages.getString("PermissionChange.Lock"), Messages.getString("PermissionChange.ReviseOtherUsersChanges"), Messages.getString("PermissionChange.UnlockOtherUsersChanges"), Messages.getString("PermissionChange.UndoOtherUsersChanges"), Messages.getString("PermissionChange.AdministerLabels"), Messages.getString("PermissionChange.ManipulateSecuritySettings"), Messages.getString("PermissionChange.CheckInOtherUsersChanges"), Messages.getString("PermissionChange.Merge"), Messages.getString("PermissionChange.ManageBranch")};
    }

    public PermissionChange(String item, String identity, String displayName, String[] allows, String[] denies, String[] removes) {
        super(new _PermissionChange(item, identity, displayName, allows, denies, removes));
        Check.notNullOrEmpty(identity, "identity");
    }

    public PermissionChange(_PermissionChange change) {
        super(change);
    }

    public _PermissionChange getWebServiceObject() {
        return (_PermissionChange)this.webServiceObject;
    }

    public String getIdentityName() {
        return this.getWebServiceObject().getIdent();
    }

    public void setIdentityName(String identityName) {
        Check.notNull(identityName, "identityName");
        this.getWebServiceObject().setIdent(identityName);
    }

    public String[] getAllow() {
        return (String[])this.getWebServiceObject().getAllow().clone();
    }

    public void setAllow(String[] allow) {
        Check.notNull(allow, "allow");
        this.getWebServiceObject().setAllow(allow);
    }

    public String[] getDeny() {
        return (String[])this.getWebServiceObject().getDeny().clone();
    }

    public void setDeny(String[] deny) {
        Check.notNull(deny, "deny");
        this.getWebServiceObject().setDeny(deny);
    }

    public String[] getRemove() {
        return (String[])this.getWebServiceObject().getRemove().clone();
    }

    public void setRemove(String[] remove) {
        Check.notNull(remove, "remove");
        this.getWebServiceObject().setRemove(remove);
    }
}

