/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.link.WorkItemLinkTypeEndCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemLinkTypeMetadata;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkType;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeCollection;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import java.util.HashMap;
import java.util.HashSet;

public class WorkItemLinkTypeCollectionImpl
implements WorkItemLinkTypeCollection {
    private final HashSet<Integer> forwardIds = new HashSet();
    private final HashSet<Integer> reverseIds = new HashSet();
    private final HashMap<Integer, String> idToReferenceName = new HashMap();
    private final HashMap<Integer, String> idToDisplayName = new HashMap();
    private final HashMap<String, WorkItemLinkType> mapByName = new HashMap();
    private final WorkItemLinkTypeEndCollection endsCollection;

    public WorkItemLinkTypeCollectionImpl(WITContext context) {
        WorkItemLinkTypeMetadata[] metadataLinkTypes = context.getMetadata().getLinkTypesTable().getLinkTypes();
        for (int i = 0; i < metadataLinkTypes.length; ++i) {
            WorkItemLinkTypeMetadata linkTypeMetaData = metadataLinkTypes[i];
            WorkItemLinkType linkType = new WorkItemLinkType(context, linkTypeMetaData);
            this.mapByName.put(linkType.getReferenceName(), linkType);
            this.forwardIds.add(new Integer(linkTypeMetaData.getForwardID()));
            this.reverseIds.add(new Integer(linkTypeMetaData.getReverseID()));
            this.idToReferenceName.put(new Integer(linkTypeMetaData.getForwardID()), linkTypeMetaData.getReferenceName());
            this.idToDisplayName.put(new Integer(linkTypeMetaData.getForwardID()), linkTypeMetaData.getForwardName());
            if (linkTypeMetaData.getForwardID() == linkTypeMetaData.getReverseID()) continue;
            this.idToReferenceName.put(new Integer(linkTypeMetaData.getReverseID()), linkTypeMetaData.getReferenceName());
            this.idToDisplayName.put(new Integer(linkTypeMetaData.getReverseID()), linkTypeMetaData.getReverseName());
        }
        this.endsCollection = new WorkItemLinkTypeEndCollectionImpl(context, this.mapByName.values().toArray(new WorkItemLinkType[this.mapByName.values().size()]));
    }

    @Override
    public String getDisplayName(int linkTypeId) {
        Integer boxedId = new Integer(linkTypeId);
        if (this.idToDisplayName.containsKey(boxedId)) {
            return this.idToDisplayName.get(boxedId);
        }
        return null;
    }

    @Override
    public String getReferenceName(int linkTypeId) {
        Integer boxedId = new Integer(linkTypeId);
        if (this.idToReferenceName.containsKey(boxedId)) {
            return this.idToReferenceName.get(boxedId);
        }
        return null;
    }

    @Override
    public boolean isForwardLink(int linkTypeId) {
        return this.forwardIds.contains(new Integer(linkTypeId));
    }

    @Override
    public boolean isReverseLink(int linkTypeId) {
        return this.reverseIds.contains(new Integer(linkTypeId));
    }

    @Override
    public boolean contains(String linkTypeReferenceName) {
        return this.mapByName.containsKey(linkTypeReferenceName);
    }

    @Override
    public WorkItemLinkType get(String referenceName) {
        return this.mapByName.get(referenceName);
    }

    @Override
    public int getCount() {
        return this.mapByName.size();
    }

    @Override
    public WorkItemLinkTypeEndCollection getLinkTypeEnds() {
        return this.endsCollection;
    }
}

