/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules.cache;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IConstantSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RulePersonScopeCache {
    private static final Log log = LogFactory.getLog(RulePersonScopeCache.class);
    private final Map<Integer, Boolean> personIds = new HashMap<Integer, Boolean>();
    private final WITContext witContext;

    public RulePersonScopeCache(WITContext witContext) {
        this.witContext = witContext;
    }

    public synchronized void clear() {
        this.personIds.clear();
    }

    public synchronized boolean isRuleInScope(int personID, boolean inversePerson) {
        Integer key = new Integer(personID);
        Boolean matches = this.personIds.get(key);
        if (matches == null) {
            matches = this.currentUserMatches(personID);
            this.personIds.put(key, matches);
        }
        return inversePerson != matches;
    }

    private boolean currentUserMatches(int personID) {
        if (-1 == personID) {
            return true;
        }
        if (-2 == personID) {
            return true;
        }
        long stTime = 0L;
        if (log.isDebugEnabled()) {
            stTime = System.currentTimeMillis();
            log.debug((Object)MessageFormat.format("currentUserMatches: getting constant set for personID={0}", Integer.toString(personID)));
        }
        IConstantSet constantSet = this.witContext.getMetadata().getConstantHandler().getConstantSet(personID, true, true, true, false, false);
        if (log.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - stTime;
            log.debug((Object)MessageFormat.format("currentUserMatches: got constant set of size={0} for personID={1} queryCount={2} in: {3} ms", constantSet.getSize(), Integer.toString(personID), constantSet.getQueryCount(), elapsed));
        }
        return constantSet.containsConstID(this.witContext.getCurrentUserConstID());
    }
}

