/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.httpclient;

import com.microsoft.tfs.core.config.ConnectionInstanceData;
import com.microsoft.tfs.core.config.EnvironmentVariables;
import com.microsoft.tfs.core.config.httpclient.ConfigurableHTTPClientFactory;
import com.microsoft.tfs.core.config.httpclient.internal.DefaultSSLProtocolSocketFactory;
import com.microsoft.tfs.core.httpclient.CookieCredentials;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpConnectionManager;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.JwtCredentials;
import com.microsoft.tfs.core.httpclient.MultiThreadedHttpConnectionManager;
import com.microsoft.tfs.core.httpclient.PreemptiveUsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.params.HttpClientParams;
import com.microsoft.tfs.core.httpclient.params.HttpConnectionManagerParams;
import com.microsoft.tfs.core.httpclient.protocol.Protocol;
import com.microsoft.tfs.core.product.CoreVersionInfo;
import com.microsoft.tfs.core.product.ProductInformation;
import com.microsoft.tfs.core.product.ProductName;
import com.microsoft.tfs.core.ws.runtime.transport.HTTPConnectionCanceller;
import com.microsoft.tfs.core.ws.runtime.transport.IdleHTTPConnectionCloser;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;

public class DefaultHTTPClientFactory
implements ConfigurableHTTPClientFactory {
    public static final String CONNECT_TIMEOUT_SECONDS_PROPERTY = "com.microsoft.tfs.core.connectTimeoutSeconds";
    public static final int CONNECT_TIMEOUT_SECONDS_DEFAULT = 30;
    public static final String SOCKET_TIMEOUT_SECONDS_PROPERTY = "com.microsoft.tfs.core.socketTimeoutSeconds";
    public static final int SOCKET_TIMEOUT_SECONDS_DEFAULT = 1800;
    public static final String MAX_TOTAL_CONNECTIONS_PROPERTY = "com.microsoft.tfs.core.maxTotalConnections";
    public static final int MAX_TOTAL_CONNECTIONS_DEFAULT = 40;
    public static final String MAX_CONNECTIONS_PER_HOST_PROPERTY = "com.microsoft.tfs.core.maxConnectionsPerHost";
    public static final int MAX_CONNECTIONS_PER_HOST_DEFAULT = 10;
    public static final String DISABLE_HTTP_CANCEL_THREAD_PROPERTY = "com.microsoft.tfs.core.disableCancelThread";
    public static final String ECLIPSE_GROUP_NAME = "Eclipse Platform";
    public static final int USER_AGENT_EXTRA_TEXT_MAX_CHARS = 30;
    public static final int USER_AGENT_OS_INFO_MAX_CHARS = 30;
    private static final Log log = LogFactory.getLog(DefaultHTTPClientFactory.class);
    private static final IdleHTTPConnectionCloser closerThread = new IdleHTTPConnectionCloser();
    private static final HTTPConnectionCanceller cancelThread = new HTTPConnectionCanceller();
    private final ConnectionInstanceData connectionInstanceData;

    public DefaultHTTPClientFactory(ConnectionInstanceData connectionInstanceData) {
        Check.notNull(connectionInstanceData, "connectionInstanceData");
        this.connectionInstanceData = connectionInstanceData;
    }

    @Override
    public HttpClient newHTTPClient() {
        HttpConnectionManager connectionManager = this.createConnectionManager(this.connectionInstanceData);
        HttpClient httpClient = this.createHTTPClient(connectionManager, this.connectionInstanceData);
        this.configureClientParams(httpClient, httpClient.getParams(), this.connectionInstanceData);
        this.configureClientCredentials(httpClient, httpClient.getState(), this.connectionInstanceData);
        this.configureClientProxy(httpClient, httpClient.getHostConfiguration(), httpClient.getState(), this.connectionInstanceData);
        this.configureClient(httpClient, this.connectionInstanceData);
        this.logHTTPClientConfiguration(httpClient);
        return httpClient;
    }

    private void logHTTPClientConfiguration(HttpClient httpClient) {
        StringBuffer configurationMessage = new StringBuffer();
        configurationMessage.append(MessageFormat.format("HttpClient configured for {0}", this.connectionInstanceData.getServerURI()));
        Credentials credentials = httpClient.getState().getCredentials(AuthScope.ANY);
        if (credentials != null) {
            if (credentials instanceof DefaultNTCredentials) {
                configurationMessage.append(", authenticating as logged in user");
            } else if (credentials instanceof UsernamePasswordCredentials) {
                configurationMessage.append(MessageFormat.format(", authenticating as {0}", ((UsernamePasswordCredentials)credentials).getUsername()));
            } else if (credentials instanceof CookieCredentials) {
                configurationMessage.append(", authenticating with ACS token");
            } else if (credentials instanceof JwtCredentials) {
                configurationMessage.append(", authenticating with JWT token");
            }
        }
        if (httpClient.getHostConfiguration().getProxyHost() != null) {
            configurationMessage.append(MessageFormat.format(", proxy={0}", httpClient.getHostConfiguration().getProxyHost()));
            if (httpClient.getHostConfiguration().getProxyPort() != -1) {
                configurationMessage.append(MessageFormat.format(":{0}", Integer.toString(httpClient.getHostConfiguration().getProxyPort())));
            }
        }
        log.info((Object)configurationMessage.toString());
    }

    @Override
    public void dispose(HttpClient httpClient) {
        log.debug((Object)"Disposing");
        HttpConnectionManager connectionManager = httpClient.getHttpConnectionManager();
        if (!(connectionManager instanceof MultiThreadedHttpConnectionManager)) {
            log.debug((Object)"Nothing to dispose: connectionManager is not an instance of MultiThreadedHttpConnectionManager");
            return;
        }
        MultiThreadedHttpConnectionManager multiThreadedConnectionManager = (MultiThreadedHttpConnectionManager)connectionManager;
        log.debug((Object)"Shutting down the Multi Threaded Http Connection Manager");
        multiThreadedConnectionManager.shutdown();
        log.debug((Object)"Disposed");
    }

    @Override
    public HttpConnectionManager createConnectionManager(ConnectionInstanceData connectionInstanceData) {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = connectionManager.getParams();
        params.setMaxTotalConnections(Integer.getInteger(MAX_TOTAL_CONNECTIONS_PROPERTY, 40));
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, Integer.getInteger(MAX_CONNECTIONS_PER_HOST_PROPERTY, 10));
        params.setConnectionTimeout(Integer.getInteger(CONNECT_TIMEOUT_SECONDS_PROPERTY, 30) * 1000);
        return connectionManager;
    }

    @Override
    public HttpClient createHTTPClient(HttpConnectionManager connectionManager, ConnectionInstanceData connectionInstanceData) {
        Protocol.registerProtocol("https", new Protocol("https", new DefaultSSLProtocolSocketFactory(), 443));
        return new HttpClient(connectionManager);
    }

    protected boolean shouldAcceptUntrustedCertificates(ConnectionInstanceData connectionInstanceData) {
        return PlatformMiscUtils.getInstance().getEnvironmentVariable("TF_ACCEPT_UNTRUSTED_CERTIFICATES") != null;
    }

    @Override
    public void configureClientParams(HttpClient httpClient, HttpClientParams params, ConnectionInstanceData connectionInstanceData) {
        params.setBooleanParameter("http.protocol.expect-continue", false);
        params.setParameter("http.socket.timeout", Integer.getInteger(SOCKET_TIMEOUT_SECONDS_PROPERTY, 1800) * 1000);
        String userAgent = this.getUserAgent(httpClient, connectionInstanceData);
        if (userAgent != null) {
            params.setParameter("http.useragent", userAgent);
        }
        if (this.shouldAcceptUntrustedCertificates(connectionInstanceData)) {
            params.setBooleanParameter("DefaultSSLProtocolSocketFactory.acceptUntrustedCertificates", Boolean.TRUE);
        }
    }

    @Override
    public final String getUserAgent(HttpClient httpClient, ConnectionInstanceData connectionInstanceData) {
        ProductName productName = ProductInformation.getCurrent();
        String applicationName = EnvironmentVariables.getBoolean("TF_USE_LEGACY_MSA", false) ? productName.getFamilyShortNameNOLOC() : "Team  Explorer  Everywhere";
        String sqmID = Integer.toString(productName.getSQMID());
        String shortName = productName.getProductShortNameNOLOC();
        String version = MessageFormat.format("{0}.{1}.{2}.{3}", CoreVersionInfo.getMajorVersion(), CoreVersionInfo.getMinorVersion(), CoreVersionInfo.getServiceVersion(), CoreVersionInfo.getBuildVersion());
        String productInfo = this.getProductInformation(shortName);
        String javaVersion = System.getProperty("java.version");
        String osInfo = this.truncate(MessageFormat.format("{0} {1} {2}", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")), 30);
        StringBuffer ua = new StringBuffer(MessageFormat.format("{0}, SKU:{1} ({2} {3} {4}{5}; {6}", applicationName, sqmID, shortName, version, productInfo, javaVersion, osInfo));
        String extra = this.getUserAgentExtraString(httpClient, connectionInstanceData);
        if (extra != null) {
            ua.append("; ");
            ua.append(this.truncate(extra, 30));
        }
        ua.append(")");
        return ua.toString();
    }

    private String truncate(String s, int maxLength) {
        if (s == null || s.length() == 0 || maxLength < 1 || s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    protected String getUserAgentExtraString(HttpClient httpClient, ConnectionInstanceData connectionInstanceData) {
        return null;
    }

    @Override
    public void configureClientCredentials(HttpClient httpClient, HttpState state, ConnectionInstanceData connectionInstanceData) {
        Credentials credentials = this.createCredentials(connectionInstanceData);
        if (credentials != null) {
            state.setCredentials(AuthScope.ANY, credentials);
        }
        httpClient.getParams().setPreemptiveAuthenticationTypes(new Class[]{CookieCredentials.class, JwtCredentials.class, UsernamePasswordCredentials.PatCredentials.class, PreemptiveUsernamePasswordCredentials.class});
    }

    protected Credentials createCredentials(ConnectionInstanceData connectionInstanceData) {
        return connectionInstanceData.getCredentials() != null ? connectionInstanceData.getCredentials() : new DefaultNTCredentials();
    }

    protected Credentials createProxyCredentials(ConnectionInstanceData connectionInstanceData) {
        return new DefaultNTCredentials();
    }

    @Override
    public void configureClientProxy(HttpClient httpClient, HostConfiguration hostConfiguration, HttpState httpState, ConnectionInstanceData connectionInstanceData) {
    }

    @Override
    public void configureClient(HttpClient httpClient, ConnectionInstanceData connectionInstanceData) {
        this.addClientToCloserThread(httpClient);
    }

    protected final void addClientToCloserThread(HttpClient httpClient) {
        closerThread.addClient(httpClient);
    }

    private final String getProductInformation(String shortName) {
        String productVendorVersion = "";
        if (shortName.equals(ProductName.PLUGIN)) {
            String[] productInfo = new String[2];
            productInfo[0] = Platform.getProduct().getName().replace(' ', '_');
            IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
            if (providers != null) {
                block0: for (IBundleGroupProvider provider : providers) {
                    for (IBundleGroup group : provider.getBundleGroups()) {
                        String groupName = group.getName();
                        String groupVersion = group.getVersion();
                        if (!groupName.equalsIgnoreCase(ECLIPSE_GROUP_NAME)) continue;
                        int index = groupVersion.indexOf(".v");
                        if (index > 0) {
                            productInfo[1] = groupVersion.substring(0, index);
                            continue block0;
                        }
                        productInfo[1] = groupVersion;
                        continue block0;
                    }
                }
            }
            if (productInfo[0] != null && productInfo[1] != null) {
                productVendorVersion = MessageFormat.format("{0} {1} ", productInfo[0], productInfo[1]);
            }
        }
        return productVendorVersion;
    }

    static {
        closerThread.start();
        if (System.getProperty(DISABLE_HTTP_CANCEL_THREAD_PROPERTY) == null) {
            cancelThread.start();
        }
    }
}

