/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.exceptions;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.ws.runtime.Messages;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportAuthException;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class UnauthorizedException
extends TransportAuthException {
    private static final long serialVersionUID = 7897261585407536688L;
    private final String uri;
    private final Credentials credentials;

    public UnauthorizedException(String uri, Credentials credentials) {
        Check.notNull(uri, "uri");
        this.uri = uri;
        this.credentials = credentials;
    }

    public String getURI() {
        return this.uri;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getMessage() {
        String message;
        if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCrendentials = (UsernamePasswordCredentials)this.credentials;
            String messageFormat = Messages.getString("UnauthorizedException.AuthorizationFailedAsFormat");
            message = MessageFormat.format(messageFormat, this.uri, upCrendentials.getUsername());
        } else if (this.credentials != null) {
            String messageFormat = Messages.getString("UnauthorizedException.AuthorizationFailedWithCredentialsFormat");
            message = MessageFormat.format(messageFormat, this.uri, this.credentials);
        } else {
            String messageFormat = Messages.getString("UnauthorizedException.AuthorizationFailedWithNoCredentialsFormat");
            message = MessageFormat.format(messageFormat, this.uri);
        }
        return message;
    }
}

