/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream;

import com.microsoft.tfs.jni.appleforked.stream.AppleForkedEncoderStream;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedCommentEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedDataForkEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedDateEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedFilenameEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedFinderInfoEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedMacFileInfoEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedResourceForkEncoder;
import com.microsoft.tfs.util.chunkingcodec.ChunkedEncoder;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class AppleSingleEncoderStream
extends AppleForkedEncoderStream {
    private String filename = null;
    private Date date = null;

    public AppleSingleEncoderStream(File file) {
        super(file, 333312);
    }

    public AppleSingleEncoderStream(String filename) {
        super(filename, 333312);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    protected AppleForkedEntryEncoder[] configureEncoders(File file) {
        AppleForkedResourceForkEncoder resourceForkEncoder;
        AppleForkedCommentEncoder commentEncoder;
        ArrayList<ChunkedEncoder> encoders = new ArrayList<ChunkedEncoder>();
        if (this.filename != null) {
            encoders.add(new AppleForkedFilenameEncoder(this.filename));
        } else {
            encoders.add(new AppleForkedFilenameEncoder(file));
        }
        if (this.date != null) {
            encoders.add(new AppleForkedDateEncoder(this.date));
        } else {
            encoders.add(new AppleForkedDateEncoder(file));
        }
        encoders.add(new AppleForkedMacFileInfoEncoder(file));
        AppleForkedFinderInfoEncoder finderInfoEncoder = new AppleForkedFinderInfoEncoder(file);
        if (finderInfoEncoder.getLength() > 0L) {
            encoders.add(new AppleForkedFinderInfoEncoder(file));
        }
        if ((commentEncoder = new AppleForkedCommentEncoder(file)).getLength() > 0L) {
            encoders.add(commentEncoder);
        }
        if ((resourceForkEncoder = new AppleForkedResourceForkEncoder(file)).getLength() > 0L) {
            encoders.add(resourceForkEncoder);
        }
        encoders.add(new AppleForkedDataForkEncoder(file));
        return encoders.toArray(new AppleForkedEntryEncoder[encoders.size()]);
    }
}

