/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.filelock;

import com.microsoft.tfs.jni.filelock.ITFSFileLock;
import com.microsoft.tfs.jni.filelock.TFSFileLockException;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class NIOFileLock
implements ITFSFileLock {
    private static final String FILE_SUFFIX = ".lock";
    private static final int POLL_TIME = 100;
    private final String filename;
    private final File lockFile;
    private volatile boolean closed = false;
    private static final ThreadLocal<Map<File, NIOFileLockData>> lockFileToDataMap = new ThreadLocal<Map<File, NIOFileLockData>>(){

        @Override
        protected Map<File, NIOFileLockData> initialValue() {
            return new HashMap<File, NIOFileLockData>();
        }
    };
    private static final Set<File> lockFiles = new HashSet<File>();

    NIOFileLock(String filename) {
        Check.notNull(filename, "filename");
        this.filename = filename;
        File targetFile = new File(filename);
        File parentFile = targetFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new TFSFileLockException(MessageFormat.format("Cannot create directory {0}", parentFile.getAbsolutePath()));
        }
        this.lockFile = new File(targetFile.getAbsoluteFile() + FILE_SUFFIX);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void acquire() {
        if (!this.acquire(-1)) {
            throw new TFSFileLockException("Could not acquire mutex");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(int timeout) {
        if (this.closed) {
            throw new TFSFileLockException("This file lock has been closed.");
        }
        boolean success = false;
        NIOFileLockData fileLockData = lockFileToDataMap.get().get(this.lockFile);
        if (fileLockData != null) {
            if (fileLockData.getAcquisitionCount() <= 0) {
                throw new TFSFileLockException(MessageFormat.format("Invalid file lock state for file {0}", this.filename));
            }
            fileLockData.acquire();
            return true;
        }
        if (timeout < 0) {
            timeout = Integer.MAX_VALUE;
        }
        try {
            int sleepTime;
            do {
                Set<File> set = lockFiles;
                synchronized (set) {
                    if (!lockFiles.contains(this.lockFile)) {
                        lockFiles.add(this.lockFile);
                        success = true;
                        break;
                    }
                }
                sleepTime = timeout < 100 ? timeout : 100;
                Thread.sleep(sleepTime);
            } while ((timeout -= sleepTime) > 0);
        }
        catch (InterruptedException e) {
            throw new TFSFileLockException("Could not acquire file lock", e);
        }
        if (!success) {
            return false;
        }
        success = false;
        RandomAccessFile raFile = null;
        try {
            int sleepTime;
            raFile = new RandomAccessFile(this.lockFile, "rw");
            do {
                FileLock lock;
                if ((lock = raFile.getChannel().tryLock()) != null) {
                    lockFileToDataMap.get().put(this.lockFile, new NIOFileLockData(raFile, lock));
                    success = true;
                    break;
                }
                sleepTime = timeout < 100 ? timeout : 100;
                Thread.sleep(sleepTime);
            } while ((timeout -= sleepTime) > 0);
        }
        catch (Exception e) {
            throw new TFSFileLockException("Could not acquire file lock", e);
        }
        finally {
            if (!success) {
                if (raFile != null) {
                    try {
                        raFile.close();
                    }
                    catch (IOException e) {}
                }
                Set<File> set = lockFiles;
                synchronized (set) {
                    lockFiles.remove(this.lockFile);
                }
            }
        }
        return success;
    }

    @Override
    public void release() {
        if (this.closed) {
            throw new TFSFileLockException("This file lock has been closed.");
        }
        NIOFileLockData fileLockData = lockFileToDataMap.get().get(this.lockFile);
        if (fileLockData == null) {
            throw new TFSFileLockException(MessageFormat.format("The lock for file {0} is not held by the calling thread", this.filename));
        }
        fileLockData.release();
        if (fileLockData.getAcquisitionCount() < 0) {
            throw new TFSFileLockException(MessageFormat.format("Inconsistent file lock state for {0}", this.filename));
        }
        if (fileLockData.getAcquisitionCount() > 0) {
            return;
        }
        try {
            fileLockData.getFileLock().release();
            fileLockData.getRandomAccessFile().close();
        }
        catch (Exception e) {
            throw new TFSFileLockException("Could not release file lock", e);
        }
        finally {
            lockFileToDataMap.get().remove(this.lockFile);
            lockFiles.remove(this.lockFile);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private static class NIOFileLockData {
        private final RandomAccessFile randomAccessFile;
        private final FileLock fileLock;
        private int acquisitionCount;

        public NIOFileLockData(RandomAccessFile randomAccessFile, FileLock fileLock) {
            Check.notNull(randomAccessFile, "randomAccessFile");
            Check.notNull(fileLock, "fileLock");
            this.randomAccessFile = randomAccessFile;
            this.fileLock = fileLock;
            this.acquisitionCount = 1;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.randomAccessFile;
        }

        public FileLock getFileLock() {
            return this.fileLock;
        }

        public int getAcquisitionCount() {
            return this.acquisitionCount;
        }

        public void acquire() {
            ++this.acquisitionCount;
        }

        public void release() {
            --this.acquisitionCount;
        }
    }
}

