/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.listeners;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.ListenerCategory;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import java.util.HashMap;
import java.util.Map;

public class MultiListenerList {
    private final Map<ListenerCategory, SingleListenerFacade> map = new HashMap<ListenerCategory, SingleListenerFacade>();
    private final Object lock = new Object();

    public boolean addListener(Object listener, ListenerCategory category) {
        Check.notNull(listener, "listener");
        Check.notNull(category, "category");
        SingleListenerFacade facade = this.getSingleListenerFacade(category, true);
        return facade.addListener(listener);
    }

    public boolean removeListener(Object listener, ListenerCategory category) {
        Check.notNull(listener, "listener");
        Check.notNull(category, "category");
        SingleListenerFacade facade = this.getSingleListenerFacade(category, false);
        if (facade == null) {
            return false;
        }
        return facade.removeListener(listener);
    }

    public ListenerList getListenerList(ListenerCategory category) {
        return this.getListenerList(category, true);
    }

    public ListenerList getListenerList(ListenerCategory category, boolean create) {
        SingleListenerFacade facade = this.getSingleListenerFacade(category, create);
        if (facade == null) {
            return null;
        }
        return facade.getListenerList();
    }

    public Object getListener(ListenerCategory category) {
        return this.getListener(category, false);
    }

    public Object getListener(ListenerCategory category, boolean allowNull) {
        SingleListenerFacade facade = this.getSingleListenerFacade(category, !allowNull);
        if (facade == null) {
            return null;
        }
        return facade.getListener(allowNull);
    }

    public boolean clear(ListenerCategory category) {
        SingleListenerFacade facade = this.getSingleListenerFacade(category, false);
        if (facade != null) {
            return facade.getListenerList().clear();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        boolean modified = false;
        Object object = this.lock;
        synchronized (object) {
            for (SingleListenerFacade facade : this.map.values()) {
                if (!facade.getListenerList().clear()) continue;
                modified = true;
            }
            this.map.clear();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleListenerFacade getSingleListenerFacade(ListenerCategory category, boolean create) {
        Object object = this.lock;
        synchronized (object) {
            SingleListenerFacade facade = this.map.get(category);
            if (facade == null && create) {
                facade = new SingleListenerFacade(category.getListenerInterface());
                this.map.put(category, facade);
            }
            return facade;
        }
    }
}

