/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.listeners;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.DefaultExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.MulticastListenerProxy;
import com.microsoft.tfs.util.listeners.StandardListenerList;
import java.text.MessageFormat;

public class SingleListenerFacade {
    private final Class listenerInterface;
    private final ListenerList listenerList;
    private final ListenerExceptionHandler exceptionHandler;
    private final Object proxyListenerLock = new Object();
    private Object proxyListener;

    public SingleListenerFacade(Class listenerInterface) {
        this(listenerInterface, new StandardListenerList(), DefaultExceptionHandler.INSTANCE);
    }

    public SingleListenerFacade(Class listenerInterface, ListenerList listenerList) {
        this(listenerInterface, listenerList, DefaultExceptionHandler.INSTANCE);
    }

    public SingleListenerFacade(Class listenerInterface, ListenerList listenerList, ListenerExceptionHandler exceptionHandler) {
        Check.notNull(listenerInterface, "listenerInterface");
        Check.notNull(listenerList, "listenerList");
        Check.notNull(exceptionHandler, "exceptionHandler");
        this.listenerInterface = listenerInterface;
        this.listenerList = listenerList;
        this.exceptionHandler = exceptionHandler;
    }

    public boolean addListener(Object listener) {
        Check.notNull(listener, "listener");
        if (!this.listenerInterface.isInstance(listener)) {
            String messageFormat = "the specified listener type [{0}] is not an instance of [{1}]";
            String message = MessageFormat.format("the specified listener type [{0}] is not an instance of [{1}]", listener.getClass().getName(), this.listenerInterface.getName());
            throw new IllegalArgumentException(message);
        }
        return this.listenerList.addListener(listener);
    }

    public boolean removeListener(Object listener) {
        return this.listenerList.removeListener(listener);
    }

    public ListenerList getListenerList() {
        return this.listenerList;
    }

    public Object getListener() {
        return this.getListener(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getListener(boolean allowNull) {
        Object[] listeners;
        Object object = this.proxyListenerLock;
        synchronized (object) {
            if (this.proxyListener != null) {
                return this.proxyListener;
            }
        }
        int size = this.listenerList.size();
        if (size == 0 && allowNull) {
            return null;
        }
        if (size == 1 && (listeners = this.listenerList.getListeners()).length == 1) {
            return listeners[0];
        }
        Object createdProxyListener = MulticastListenerProxy.createProxy(this.listenerInterface, this.listenerList, this.exceptionHandler);
        Object object2 = this.proxyListenerLock;
        synchronized (object2) {
            this.proxyListener = createdProxyListener;
            return this.proxyListener;
        }
    }
}

