/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.Set;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class IndexValidationUtils {
    private static final Set<Class<? extends IStorageIndex>> ALLOWED_STORAGE_INTERFACES = CollectionUtils.asHashSet((Object[])new Class[]{IGlobalIndex.class, IProjectIndex.class, IProjectIndexWithDynamicName.class});

    public static void validateIndexClass(Class<?> indexClass) {
        if (!indexClass.isAnnotationPresent(Index.class)) {
            throw new IllegalStateException(indexClass.getName() + " is not annotated with @" + Index.class.getSimpleName() + "!");
        }
        if (!IStorageIndex.class.isAssignableFrom(indexClass)) {
            throw new IllegalStateException(indexClass.getName() + " is annotated with @" + Index.class.getSimpleName() + " but does not implement " + IStorageIndex.class.getSimpleName() + "!");
        }
        int countImplementedStorageInterfaces = (int)ALLOWED_STORAGE_INTERFACES.stream().filter(storageInterface -> storageInterface.isAssignableFrom(indexClass)).count();
        if (countImplementedStorageInterfaces == 0) {
            throw new IllegalStateException(indexClass.getName() + " is annotated with @" + Index.class.getSimpleName() + " but does not implement exactly one of the following interfaces: " + String.valueOf(ALLOWED_STORAGE_INTERFACES));
        }
        if (countImplementedStorageInterfaces > 1 && indexClass != MetaIndex.class) {
            throw new IllegalStateException(indexClass.getName() + " implements more than one of the following interfaces: " + String.valueOf(ALLOWED_STORAGE_INTERFACES));
        }
    }

    private IndexValidationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

