/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.StaticOperand;

public abstract class BasicQueryBase
implements IQuery {
    protected final IAttributeOperand attribute;
    protected final StaticOperand value;

    protected BasicQueryBase(IAttributeOperand attribute, StaticOperand value) {
        this.attribute = attribute;
        this.value = value;
    }

    @Override
    public <T> Predicate<T> compile(ICompilationContext<T> context) throws QueryCompilationException {
        EKeyedObjectType type = this.attribute.getType(context);
        BiPredicate<Object, Object> comparator = this.getComparator(type);
        Function valueAccessor = this.attribute.getValueAccessor(context);
        Object convertedValue = this.value.convertTo(type);
        return object -> {
            Object value = valueAccessor.apply(object);
            if (value == null) {
                return false;
            }
            return comparator.test(value, convertedValue);
        };
    }

    protected abstract BiPredicate<Object, Object> getComparator(EKeyedObjectType var1) throws QueryCompilationException;

    public String toString() {
        return "(" + String.valueOf(this.attribute) + " " + this.getReadableOperator() + " " + String.valueOf(this.value) + ")";
    }

    protected abstract String getReadableOperator();
}

