/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.leveldb;

import java.io.File;
import leveldb.LevelDB;
import leveldb.SWIGTYPE_p_leveldb_cache_t;
import leveldb.SWIGTYPE_p_leveldb_options_t;
import leveldb.SWIGTYPE_p_leveldb_t;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.util.NativeLibUtil;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.SingleStoreStorageSystemProviderBase;
import org.conqat.engine.persistence.store.base.StorageSystemBase;
import org.conqat.engine.persistence.store.leveldb.LevelDBStore;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.system.SystemUtils;

public class LevelDBStorageSystemProvider
extends SingleStoreStorageSystemProviderBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean librariesLoaded = false;
    private final SWIGTYPE_p_leveldb_options_t options;
    private final SWIGTYPE_p_leveldb_cache_t cache;
    private final SWIGTYPE_p_leveldb_t db;

    public LevelDBStorageSystemProvider(File dir, int cacheSizeMB) throws StorageException {
        if (SystemUtils.isArm64Architecture()) {
            throw new StorageException("The storage system LevelDB is not supported on ARM-based platforms. Please switch to RocksDB or Xodus instead.");
        }
        LevelDBStorageSystemProvider.loadLibraries();
        StorageSystemBase.ensureStorageDirectoryExists(dir);
        this.options = LevelDB.leveldb_options_create();
        LevelDB.leveldb_options_set_create_if_missing((SWIGTYPE_p_leveldb_options_t)this.options, (short)1);
        this.cache = LevelDB.leveldb_cache_create_lru((long)ByteUnit.MEBIBYTES.toBytes((long)cacheSizeMB));
        LevelDB.leveldb_options_set_cache((SWIGTYPE_p_leveldb_options_t)this.options, (SWIGTYPE_p_leveldb_cache_t)this.cache);
        String[] error = new String[1];
        this.db = LevelDB.leveldb_open((SWIGTYPE_p_leveldb_options_t)this.options, (String)dir.getAbsolutePath(), (String[])error);
        LevelDBStorageSystemProvider.checkError(error);
        this.init(new LevelDBStore(this.db, this));
    }

    static void checkError(String[] error) throws StorageException {
        if (error[0] != null) {
            Object message = error[0];
            if (((String)message).endsWith("LOCK: Resource temporarily unavailable")) {
                message = "LevelDB storage locked. Please ensure that no other running Teamscale instance is using this storage: " + (String)message;
            }
            throw new StorageException((String)message);
        }
    }

    private static synchronized void loadLibraries() {
        if (librariesLoaded) {
            return;
        }
        String libraryName = LevelDBStorageSystemProvider.determineLibraryName();
        LOGGER.info("LevelDB store using library {}", (Object)libraryName);
        File levelDbLib = NativeLibUtil.getNativeLib((String)("leveldb/" + libraryName));
        Runtime.getRuntime().load(levelDbLib.getAbsolutePath());
        librariesLoaded = true;
    }

    private static String determineLibraryName() {
        String extension = "";
        if (SystemUtils.is64BitJVM()) {
            extension = "64";
        }
        return switch (SystemUtils.getOperatingSystem()) {
            case SystemUtils.EOperatingSystem.WINDOWS -> "leveldbjni-windows" + extension + ".dll";
            case SystemUtils.EOperatingSystem.LINUX -> "libleveldbjni-linux" + extension + ".so";
            case SystemUtils.EOperatingSystem.MAC -> "libleveldbjni-mac" + extension + ".so";
            default -> throw new AssertionError((Object)("Unsupported operating system: " + SystemUtils.getOperatingSystemName()));
        };
    }

    @Override
    public void runFullCompaction() {
        if (!this.doesOsSupportCompaction()) {
            LOGGER.error("LevelDB: Full compaction is not supported under Windows.");
            return;
        }
        LevelDB.leveldb_compact_range((SWIGTYPE_p_leveldb_t)this.db, null, (long)-1L, null, (long)-1L);
    }

    @Override
    public void close() {
        super.close();
        LevelDB.leveldb_close((SWIGTYPE_p_leveldb_t)this.db);
        LevelDB.leveldb_cache_destroy((SWIGTYPE_p_leveldb_cache_t)this.cache);
        LevelDB.leveldb_options_destroy((SWIGTYPE_p_leveldb_options_t)this.options);
    }

    @Override
    protected String getStorageSystemName() {
        return "LevelDB storage system";
    }

    @Override
    protected boolean doesOsSupportCompaction() {
        return !SystemUtils.isWindows();
    }
}

