/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.accounts;

import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.ESystemType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ExternalCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String credentialsName;
    public final String uri;
    public final String username;
    public final String password;
    private long lastChangeTimestamp = 0L;
    private String lastChangeUser = null;
    public final ConnectorTypeInfo connectorTypeInfo;

    public ExternalCredentials(String credentialsName, String uri, String username, String password, ConnectorTypeInfo connectorTypeInfo) {
        CCSMAssert.isNotEmpty((String)credentialsName, (String)"Account name can't be empty.");
        CCSMAssert.isNotEmpty((String)uri, (String)"URI can't be empty.");
        CCSMAssert.isNotNull((Object)username, (String)"Username can't be null.");
        CCSMAssert.isNotNull((Object)password, (String)"Password can't be null.");
        CCSMAssert.isNotNull((Object)connectorTypeInfo, (String)"System type can't be null.");
        this.credentialsName = credentialsName.trim();
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.connectorTypeInfo = connectorTypeInfo;
    }

    public ExternalCredentials(String credentialsName, String uri, String username, String password) {
        this(credentialsName, uri, username, password, new ConnectorTypeInfo());
    }

    public ExternalCredentials(String credentialsName, String uri) {
        this(credentialsName, uri, "", "");
    }

    public ExternalCredentials(String credentialsName, Path path) {
        this(credentialsName, path.toUri().toString(), "", "");
    }

    public void setLastChangeInformation(String username, long timestamp) {
        this.lastChangeUser = username;
        this.lastChangeTimestamp = timestamp;
    }

    public long getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    public @Nullable String getLastChangeUser() {
        return this.lastChangeUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalCredentials that = (ExternalCredentials)o;
        return Objects.equals(this.credentialsName, that.credentialsName) && Objects.equals(this.uri, that.uri) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.connectorTypeInfo, that.connectorTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.credentialsName, this.uri, this.username, this.password, this.connectorTypeInfo);
    }

    @IndexValueClass(containedInBackup=true)
    public static class ConnectorTypeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final EConnectorType connectorType;
        public final IConnectorEnum<?> connectorEnum;

        public ConnectorTypeInfo(EConnectorType connectorType, IConnectorEnum<?> connectorEnum) {
            CCSMAssert.isNotNull((Object)((Object)connectorType), (String)"Connector type can't be null.");
            CCSMAssert.isNotNull(connectorEnum, (String)"Connector enum can't be null.");
            this.connectorType = connectorType;
            this.connectorEnum = connectorEnum;
        }

        public ConnectorTypeInfo() {
            this.connectorType = EConnectorType.SYSTEM_TYPE;
            this.connectorEnum = ESystemType.MULTIPLE_SYSTEMS;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectorTypeInfo that = (ConnectorTypeInfo)o;
            return this.connectorType == that.connectorType && Objects.equals(this.connectorEnum, that.connectorEnum);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.connectorType, this.connectorEnum});
        }
    }
}

