/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.accounts;

import com.teamscale.core.accounts.IExternalCredentialsProvider;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jetbrains.annotations.VisibleForTesting;

public final class ExternalCredentialsProviderRegistry {
    private final Set<IExternalCredentialsProvider> providers = new HashSet<IExternalCredentialsProvider>();

    public synchronized void registerProvider(IExternalCredentialsProvider externalCredentialsProvider) {
        this.providers.add(externalCredentialsProvider);
    }

    synchronized UnmodifiableSet<IExternalCredentialsProvider> getProviders() {
        return UnmodifiableSet.of(this.providers);
    }

    public static ExternalCredentialsProviderRegistry getInstance() {
        return Singleton.INSTANCE.instance;
    }

    @VisibleForTesting
    ExternalCredentialsProviderRegistry() {
    }

    private static enum Singleton {
        INSTANCE(new ExternalCredentialsProviderRegistry());

        private final ExternalCredentialsProviderRegistry instance;

        private Singleton(ExternalCredentialsProviderRegistry instance) {
            this.instance = instance;
        }
    }
}

