/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.teamscale.commons.docs.TeamscaleDocsReference;
import com.teamscale.core.analysis.configuration.model.EAnalysisToolCategory;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum EAnalysisTool {
    TEAMSCALE("Teamscale", EAnalysisToolCategory.INTERNAL, true, "http://www.teamscale.com/", ELanguage.values()),
    FINDBUGS("Findbugs/Spotbugs", EAnalysisToolCategory.STATIC_BYTE_CODE_ANALYSIS, false, "http://findbugs.sourceforge.net/", ELanguage.JAVA),
    STYLECOP("StyleCop", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/DotNetAnalyzers/StyleCopAnalyzers", ELanguage.CS),
    RAEX("RA\u00cbX \u2013 Roslyn Analyzer Executor", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/cqse/raex", false, new ELanguage[]{ELanguage.CS}){

        @Override
        public boolean isAvailable() {
            return EFeatureToggle.ENABLE_RAEX.isEnabled() || EFeatureToggle.ENABLE_DEV_MODE.isEnabled();
        }
    }
    ,
    CS_COMPILER("C# Compiler", EAnalysisToolCategory.COMPILER_WARNINGS, false, "http://msdn.microsoft.com/en-us/library/ms228296.aspx", ELanguage.CS),
    FXCOP("FxCop", EAnalysisToolCategory.STATIC_BYTE_CODE_ANALYSIS, false, "http://msdn.microsoft.com/en-us/library/bb429476(v=vs.80).aspx", ELanguage.CS, ELanguage.VB),
    CLANG("Clang Static Analyzer", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "http://clang-analyzer.llvm.org/", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    CLANG_TIDY("Clang-Tidy", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://clang.llvm.org/extra/clang-tidy/", false, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP),
    PC_LINT("PC-Lint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "http://www.gimpel.com/html/pcl.htm", false, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    PYLINT("Pylint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "https://pylint.pycqa.org/", ELanguage.PYTHON),
    CODE_INSPECTOR("Code Inspector", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "http://help.sap.com/saphelp_nw75/helpdata/en/49/205531d0fc14cfe10000000a42189b/content.htm", true, ELanguage.ABAP),
    JACOCO("JaCoCo", EAnalysisToolCategory.TEST_COVERAGE, false, "http://www.eclemma.org/jacoco/", ELanguage.JAVA, ELanguage.GROOVY, ELanguage.KOTLIN),
    COBERTURA("Cobertura", EAnalysisToolCategory.TEST_COVERAGE, false, "http://cobertura.github.io/cobertura/", ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS),
    OPEN_COVER("OpenCover", EAnalysisToolCategory.TEST_COVERAGE, false, "https://github.com/OpenCover/opencover", ELanguage.CS),
    CLOVER("Clover", EAnalysisToolCategory.TEST_COVERAGE, false, "https://www.atlassian.com/de/software/clover", ELanguage.JAVA, ELanguage.GROOVY, ELanguage.PHP),
    GCOV("gcov", EAnalysisToolCategory.TEST_COVERAGE, false, "http://gcc.gnu.org/onlinedocs/gcc/Gcov.html", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    LCOV("lcov", EAnalysisToolCategory.TEST_COVERAGE, false, "http://ltp.sourceforge.net/coverage/lcov.php", ELanguage.JAVASCRIPT, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    COVERAGE_PY("coverage.py (Cobertura format)", EAnalysisToolCategory.TEST_COVERAGE, false, "https://pypi.python.org/pypi/coverage", ELanguage.PYTHON),
    VISUALSTUDIO_TESTCOVERAGE("Visual Studio Test Coverage", EAnalysisToolCategory.TEST_COVERAGE, false, "http://msdn.microsoft.com/en-us/vstudio/", ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.VB),
    DOT_COVER("dotCover", EAnalysisToolCategory.TEST_COVERAGE, false, "https://www.jetbrains.com/dotcover/", ELanguage.CS),
    XR_BABOON("XR.Baboon", EAnalysisToolCategory.TEST_COVERAGE, false, "https://github.com/inorton/XR.Baboon", ELanguage.CS),
    CTC_TESTCOVERAGE("CTC Test Coverage", EAnalysisToolCategory.TEST_COVERAGE, false, "http://www.testwell.fi/ctcdesc.html", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    BULLSEYE_TESTCOVERAGE("Bullseye Test Coverage", EAnalysisToolCategory.TEST_COVERAGE, false, "http://www.bullseye.com", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    SAP_SCOV("SAP SCOV", EAnalysisToolCategory.TEST_COVERAGE, false, "http://help.sap.com/saphelp_nw75/helpdata/en/49/216c634ab514cde10000000a42189b/content.htm", ELanguage.ABAP),
    KUBE_SCORE("kube-score", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "http://kube-score.com/", true, ELanguage.KUBERNETES),
    ESLINT("ESLint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "http://eslint.org/", false, ELanguage.JAVASCRIPT),
    ABAPLINT("ABAPLint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/abaplint/abaplint", false, ELanguage.ABAP),
    CUSTOM("Custom External Findings", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, TeamscaleDocsReference.getDocsUrl((String)"reference/ui/project/external-findings-descriptions"), ELanguage.values()),
    ROSLYN("Roslyn Analyzer Findings", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "https://github.com/dotnet/roslyn", ELanguage.CS, ELanguage.VB),
    CPPCHECK("Cppcheck Report Uploads", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "http://cppcheck.sourceforge.net/", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    CPPCHECK_INTERNAL("Cppcheck", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "http://cppcheck.sourceforge.net/", false, new ELanguage[]{ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}){

        @Override
        public boolean isAvailable() {
            return !EFeatureToggle.CPPCHECK_PREMIUM_LICENSED.isEnabled();
        }
    }
    ,
    CPPCHECK_PREMIUM("Cppcheck Premium", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "http://cppcheck.sourceforge.net/", false, new ELanguage[]{ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}){

        @Override
        public boolean isAvailable() {
            return EFeatureToggle.CPPCHECK_PREMIUM_LICENSED.isEnabled();
        }
    }
    ,
    CUSTOM_METRICS("Custom External Metrics", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, TeamscaleDocsReference.getDocsUrl((String)"reference/ui/project/external-metric-descriptions/"), ELanguage.values()),
    PLSQL_HPROF("PL/SQL Hierarchical Profiler", EAnalysisToolCategory.TEST_COVERAGE, false, "http://docs.oracle.com/cd/B28359_01/appdev.111/b28424/adfns_profiler.htm#CHDBHDFE", ELanguage.PLSQL),
    ASTREE("Absint Astr\u00e9e", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "https://www.absint.com/astree/index.htm", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    MODEL_ADVISOR("Model Advisor", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "https://de.mathworks.com/help/simulink/ug/select-and-run-model-advisor-checks.html", ELanguage.SIMULINK),
    SONAR_LINT("SonarLint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://www.sonarlint.org/", true, ELanguage.JAVA, ELanguage.KOTLIN, ELanguage.PHP, ELanguage.CS, ELanguage.JAVASCRIPT),
    PARASOFT_CPP_TEST("Parasoft C/C++test", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "https://www.parasoft.com/products/ctest", ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C),
    MYPY("Mypy", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, false, "http://mypy-lang.org/", ELanguage.PYTHON),
    JQASSISTANT("jQAssistant", EAnalysisToolCategory.STATIC_BYTE_CODE_ANALYSIS, false, "https://jqassistant.org/", ELanguage.JAVA, ELanguage.JAVASCRIPT),
    SWIFT_LINT("SwiftLint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/realm/SwiftLint", false, ELanguage.SWIFT),
    SEMGREP("Gitlab SAST/Semgrep", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://semgrep.dev", false, ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS, ELanguage.GO, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.SWIFT, ELanguage.PYTHON, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP),
    POWERSHELL_SCRIPT_ANALYZER("PowerShellScriptAnalyzer", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/PowerShell/PSScriptAnalyzer", ELanguage.POWERSHELL),
    SECURITY_CODE_SCAN("Security Code Scan", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/dotnetarium/DotnetariumSCS", ELanguage.CS),
    FLAKE8("Flake8", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://flake8.pycqa.org", ELanguage.PYTHON),
    BANDIT("Bandit", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://bandit.readthedocs.io/", ELanguage.PYTHON),
    DART_LINT("Dart Linter", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://github.com/dart-lang/linter", ELanguage.DART),
    GOLANG_CI_LINT("Golangci-lint", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, " https://golangci-lint.run", true, ELanguage.GO),
    PHPSTAN("PHPStan", EAnalysisToolCategory.STATIC_SOURCE_CODE_ANALYSIS, true, "https://phpstan.org/", ELanguage.PHP);

    private final String readableName;
    private final EAnalysisToolCategory category;
    private final boolean internal;
    private final String url;
    private final boolean enabledByDefault;
    private final Set<ELanguage> supportedLanguages = EnumSet.noneOf(ELanguage.class);
    public static final Set<EAnalysisTool> CUSTOM_FINDINGS_TOOLS;

    private EAnalysisTool(String readableName, EAnalysisToolCategory category, boolean internal, String url, ELanguage ... supportedLanguages) {
        this(readableName, category, internal, url, internal, supportedLanguages);
    }

    private EAnalysisTool(String readableName, EAnalysisToolCategory category, boolean internal, String url, boolean enabledByDefault, ELanguage ... supportedLanguages) {
        this.readableName = readableName;
        this.category = category;
        this.internal = internal;
        this.url = url;
        this.enabledByDefault = enabledByDefault;
        this.supportedLanguages.addAll(Arrays.asList(supportedLanguages));
    }

    public String getReadableName() {
        return this.readableName;
    }

    public String getUrl() {
        return this.url;
    }

    public EAnalysisToolCategory getCategory() {
        return this.category;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isAvailableAndSupportsOneOf(Collection<ELanguage> languages) {
        if (!this.isAvailable()) {
            return false;
        }
        for (ELanguage language : languages) {
            if (!this.supportedLanguages.contains(language)) continue;
            return true;
        }
        return false;
    }

    public static Set<EAnalysisTool> getAllToolsFor(ELanguage language) {
        return EAnalysisTool.getAllToolsFor(EnumSet.of(language));
    }

    public static Set<EAnalysisTool> getAllToolsFor(Set<ELanguage> languages) {
        EnumSet<EAnalysisTool> result = EnumSet.noneOf(EAnalysisTool.class);
        for (EAnalysisTool tool : EAnalysisTool.values()) {
            for (ELanguage language : languages) {
                if (!tool.isAvailableAndSupportsOneOf(CollectionUtils.asHashSet((Object[])new ELanguage[]{language}))) continue;
                result.add(tool);
            }
        }
        return result;
    }

    public UnmodifiableSet<ELanguage> getSupportedLanguages() {
        return CollectionUtils.asUnmodifiable(this.supportedLanguages);
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public static EAnalysisTool fromName(String name) {
        for (EAnalysisTool analysisTool : EAnalysisTool.values()) {
            if (!analysisTool.readableName.equalsIgnoreCase(name)) continue;
            return analysisTool;
        }
        return null;
    }

    public static Set<EAnalysisTool> getAlwaysAvailableTools() {
        return EnumSet.allOf(EAnalysisTool.class).stream().filter(tool -> !tool.isInternal() || tool == TEAMSCALE).collect(Collectors.toSet());
    }

    static {
        CUSTOM_FINDINGS_TOOLS = CollectionUtils.asHashSet((Object[])new EAnalysisTool[]{ROSLYN, PARASOFT_CPP_TEST, CUSTOM});
    }
}

