/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.connectors.authentication;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorModuleBase;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CredentialsConnectorModule
extends ConnectorModuleBase {
    public static final String UNAVAILABLE_ACCOUNT_IDENTIFIER = "account identifier unavailable";
    @ConfigExposed(name="Account", description="The account for this connector.", required=true)
    private @Nullable AccountCredentials accountIdentifier;
    private final AccountDetailsValidation accountDetailsValidation;
    private final boolean stripTrailingSlashFromUrl;
    private final boolean validateConnection;

    public CredentialsConnectorModule(AccountDetailsValidation accountDetailsValidation, boolean stripTrailingSlashFromUrl, boolean validateConnection) {
        this.accountDetailsValidation = accountDetailsValidation;
        this.stripTrailingSlashFromUrl = stripTrailingSlashFromUrl;
        this.validateConnection = validateConnection;
    }

    public CredentialsConnectorModule(AccountDetailsValidation accountDetailsValidation, boolean stripTrailingSlashFromUrl) {
        this(accountDetailsValidation, stripTrailingSlashFromUrl, true);
    }

    @TestOnly
    public CredentialsConnectorModule(@Nullable AccountCredentials accountIdentifier, AccountDetailsValidation accountDetailsValidation) {
        this.accountDetailsValidation = accountDetailsValidation;
        this.accountIdentifier = accountIdentifier;
        this.stripTrailingSlashFromUrl = false;
        this.validateConnection = false;
    }

    @TestOnly
    public CredentialsConnectorModule(@Nullable AccountCredentials accountIdentifier) {
        this.accountDetailsValidation = (url, username, password) -> {};
        this.accountIdentifier = accountIdentifier;
        this.stripTrailingSlashFromUrl = false;
        this.validateConnection = false;
    }

    @TestOnly
    public void setExternalAccount(AccountCredentials credentials) {
        this.accountIdentifier = credentials;
    }

    @Override
    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
    }

    @Override
    protected void validate(ConfigurationInitializationContext context) throws ConnectorValidationException {
        ExternalCredentials externalCredentials = this.resolveExternalCredentials(context.getExternalCredentialsProvider());
        this.validateHttpConnection(externalCredentials.uri);
        this.accountDetailsValidation.validate(externalCredentials.uri, externalCredentials.username, externalCredentials.password);
    }

    private String preprocessUri(String uri) throws ConnectorValidationException {
        if (this.stripTrailingSlashFromUrl) {
            uri = StringUtils.stripSuffix((String)uri, (String)"/");
        }
        if (StringUtils.isEmpty((String)uri)) {
            throw new ConnectorValidationException("Please enter a valid url!");
        }
        return uri;
    }

    private void validateHttpConnection(String url) throws ConnectorValidationException {
        if (!this.validateConnection) {
            return;
        }
        try {
            URL testUrl = new URL(url);
            URLConnection connection = testUrl.openConnection();
            connection.connect();
        }
        catch (IOException e) {
            throw new ConnectorValidationException("Could not connect to: " + url, e);
        }
    }

    public ExternalCredentials resolveExternalCredentials(IExternalCredentialsProvider externalCredentialsProvider) throws ConnectorValidationException {
        try {
            String credentialsName = this.getCredentialsName();
            ExternalCredentials externalCredentials = (ExternalCredentials)ObjectUtils.requireNonNullElseThrow((Object)externalCredentialsProvider.getExternalCredentials(credentialsName), () -> new StorageException("Credentials with name '%s' not found.".formatted(credentialsName)));
            return new ExternalCredentials(externalCredentials.credentialsName, this.preprocessUri(externalCredentials.uri), externalCredentials.username, externalCredentials.password, externalCredentials.connectorTypeInfo);
        }
        catch (StorageException e) {
            throw new ConnectorValidationException("Failed to resolve external credentials.", e);
        }
    }

    public String getCredentialsName() {
        return Optional.ofNullable(this.accountIdentifier).map(AccountCredentials::getAccountIdentifier).orElse(UNAVAILABLE_ACCOUNT_IDENTIFIER);
    }

    @FunctionalInterface
    public static interface AccountDetailsValidation {
        public void validate(String var1, String var2, String var3) throws ConnectorValidationException;
    }
}

