/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.findings.metrics.FindingsCountMetric;
import com.teamscale.core.findings.metrics.FindingsMetricBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;

public class FindingsDensityMetricBase
extends FindingsMetricBase {
    private static final String RAW_SUFFIX = "-raw";
    protected static final EMetricValueType METRIC_VALUE_TYPE = EMetricValueType.NUMERIC;
    protected static final MetricDirectorySchemaEntry.EAggregation METRIC_AGGREGATION = MetricDirectorySchemaEntry.EAggregation.NONE;
    private final String rawId;
    private final String rawName;
    private final String rawDescription;
    protected final FindingsCountMetric baseMetric;
    protected final String denominatorMetricName;
    protected final double normalizationFactor;

    public FindingsDensityMetricBase(FindingsCountMetric baseMetric, String baseName, String baseDescription, String rawBaseDescription, String denominatorMetricName, double normalizationFactor) {
        super(FindingsDensityMetricBase.generateIdFromName(baseName + FindingsDensityMetricBase.getColorString(baseMetric.color, "-", ""), new String[0]), baseName + FindingsDensityMetricBase.getColorString(baseMetric.color, " (", ")", true), String.format(baseDescription, FindingsDensityMetricBase.getColorString(baseMetric.color, " ", "")), baseMetric.color);
        this.baseMetric = baseMetric;
        this.rawId = this.id + RAW_SUFFIX;
        this.rawName = "Raw " + this.name;
        this.rawDescription = String.format(rawBaseDescription, FindingsDensityMetricBase.getColorString(baseMetric.color, " ", ""));
        this.denominatorMetricName = denominatorMetricName;
        this.normalizationFactor = normalizationFactor;
    }

    public FindingsDensityMetricBase(String id, String categoryName, String baseName, String description, String rawDescription, FindingsCountMetric baseMetric, String denominatorMetricName, double normalizationFactor) {
        super(id, baseName + " in " + categoryName + FindingsDensityMetricBase.getColorString(baseMetric.color, " (", ")", true), description, baseMetric.color);
        this.rawId = id + RAW_SUFFIX;
        this.rawName = "Raw " + baseName + " in " + categoryName + FindingsDensityMetricBase.getColorString(baseMetric.color, " (", ")", true);
        this.rawDescription = rawDescription;
        this.baseMetric = baseMetric;
        this.denominatorMetricName = denominatorMetricName;
        this.normalizationFactor = normalizationFactor;
    }

    @Override
    public void registerInSchema(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric(this.rawId, schema.createDivisionMetricSource(this.baseMetric.getId(), this.denominatorMetricName), this.rawName, this.rawDescription, METRIC_VALUE_TYPE, METRIC_AGGREGATION, EMetricProperty.HIDDEN);
        schema.addMetric(this.getId(), schema.createNormalizationMetricSource(this.rawId, this.normalizationFactor), this.getName(), this.getDescription(), METRIC_VALUE_TYPE, METRIC_AGGREGATION, new EMetricProperty[0]);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getRawId() {
        return this.rawId;
    }
}

