/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.SchedulingData;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ProjectDiscoveryHelper {
    public static final String PROJECT_DISCOVERY_LOCK_NAME = "ProjectDiscoveryHelperLock";
    private final ProjectIndex projectIndex;
    private final SchedulingData schedulingData;
    private final ILockProvider lockProvider;

    public ProjectDiscoveryHelper(ProjectIndex projectIndex, SchedulingData schedulingData, ILockProvider lockProvider) {
        this.projectIndex = projectIndex;
        this.schedulingData = schedulingData;
        this.lockProvider = lockProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProjectDiscovery() throws StorageException, TriggerCompilationException {
        Lock lock = this.lockProvider.obtainLock(PROJECT_DISCOVERY_LOCK_NAME);
        if (lock.tryLock()) {
            try {
                List<InternalProjectId> allProjects = this.projectIndex.getAllInternalProjectIds();
                allProjects.add(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID);
                Set ownedProjects = CollectionUtils.filterToSet(allProjects, ProjectDiscoveryHelper::shouldOwnProject);
                this.schedulingData.synchronizeProjects(ownedProjects);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static boolean shouldOwnProject(InternalProjectId projectId) {
        return true;
    }
}

