
Some operations on primitive types are idempotent and can be removed.

**BAD:**

```dart
doubleValue.toDouble();

intValue.toInt();
intValue.round();
intValue.ceil();
intValue.floor();
intValue.truncate();

string.toString();
string = 'hello\n'
    ''
    'world';

'string with ${x.toString()}';
```

Note that the empty string literals at the beginning or end of a string are
allowed, as they are typically used to format the string literal across multiple
lines:

```dart
// OK
string = ''
    'hello\n'
    'world\n';

// OK
string = 'hello\n'
    'world\n'
    '';
```