<h2>Why is this an issue?</h2>
<p>Fields should not be part of an API, and therefore should always be private. Indeed, they cannot be added to an interface for instance, and
validation cannot be added later on without breaking backward compatibility. Instead, developers should encapsulate their fields into properties.
Explicit property getters and setters can be introduced for validation purposes or to smooth the transition to a newer system.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Foo
{
  public int MagicNumber = 42;
}
</pre>
<h3>Compliant solution</h3>
<pre>
public class Foo
{
  public int MagicNumber
  {
    get { return 42; }
  }
}
</pre>
<p>or</p>
<pre>
public class Foo
{
  private int MagicNumber = 42;
}
</pre>
<h3>Exceptions</h3>
<p><code>struct</code>s are ignored, as are <code>static</code> and <code>const</code> fields in classes.</p>
<p>Further, an issue is only raised when the real accessibility is <code>public</code>, taking into account the class accessibility.</p>

