<h2>Why is this an issue?</h2>
<p>Passing a parameter by reference, which is what happens when you use the <code>out</code> or <code>ref</code> parameter modifiers, means that the
method will receive a pointer to the argument, rather than the argument itself. If the argument was a value type, the method will be able to change
the argument’s values. If it was a reference type, then the method receives a pointer to a pointer, which is usually not what was intended. Even when
it is what was intended, this is the sort of thing that’s difficult to get right, and should be used with caution.</p>
<p>This rule raises an issue when <code>out</code> or <code>ref</code> is used on a non-<code>Optional</code> parameter in a public method.
<code>Optional</code> parameters are covered by {rule:csharpsquid:S3447}.</p>
<h3>Noncompliant code example</h3>
<pre>
public void GetReply(
         ref MyClass input, // Noncompliant
         out string reply)  // Noncompliant
{ ... }
</pre>
<h3>Compliant solution</h3>
<pre>
public string GetReply(MyClass input)
{ ... }

public bool TryGetReply(MyClass input, out string reply)
{ ... }

public ReplyData GetReply(MyClass input)
{ ... }

internal void GetReply(ref MyClass input, out string reply)
{ ... }
</pre>
<h3>Exceptions</h3>
<p>This rule will not raise issues for:</p>
<ul>
  <li> non-public methods </li>
  <li> methods with only 'out' parameters, name starting with "Try" and return type bool. </li>
  <li> interface implementation methods </li>
</ul>

