## SA1132

<table>
<tr>
  <td>TypeName</td>
  <td>SA1132DoNotCombineFields</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1132</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

Two or more fields were declared in the same field declaration syntax.

## Rule description

A violation of this rule occurs when two fields are declared as part of the same field definition.

For example, the following code would produce a violation of this rule:

```csharp
public class TypeName
{
    private int field1,
        field2; // SA1132
}
```

The following code would not produce any violations:

```csharp
public class TypeName
{
    private int field1;
    private int field2;
}
```

## How to fix violations

To fix a violation of this rule, declare each field as part of its own field definition.

## How to suppress violations

```csharp
public class TypeName
{
    private int field1,
#pragma warning disable SA1132 // Do not combine fields
        field2;
#pragma warning restore SA1132 // Do not combine fields
}
```
